/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.entity.IMixinPlayerEntity;
import fi.dy.masa.malilib.util.ItemType;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1258;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1730;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2291;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9323;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class InventoryUtils {
    public static final Pattern PATTERN_ITEM_BASE = Pattern.compile("^(?<name>(?:[a-z0-9\\._-]+:)[a-z0-9\\._-]+)$");

    public static boolean areStacksEqual(class_1799 stack1, class_1799 stack2) {
        return InventoryUtils.areStacksAndNbtEqual(stack1, stack2);
    }

    public static boolean areStacksAndNbtEqual(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static boolean areStacksEqualIgnoreNbt(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_7984((class_1799)stack1, (class_1799)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(class_1799 stack1, class_1799 stack2) {
        class_1799 ref = stack1.method_7972();
        class_1799 check = stack2.method_7972();
        ref.method_7939(1);
        check.method_7939(1);
        if (ref.method_7963() && ref.method_7986()) {
            ref.method_7974(0);
        }
        if (check.method_7963() && check.method_7986()) {
            check.method_7974(0);
        }
        return class_1799.method_31577((class_1799)ref, (class_1799)check);
    }

    public static <T> boolean areNbtEqualIgnoreKeys(@Nonnull class_9323 tag1, @Nonnull class_9323 tag2, @Nullable class_9331<T> type, @Nullable Set<class_9331<T>> ignoredKeys) {
        Set keys1 = tag1.method_57831();
        Set keys2 = tag2.method_57831();
        if (ignoredKeys != null) {
            keys1.removeAll(ignoredKeys);
            keys2.removeAll(ignoredKeys);
        }
        if (!Objects.equals(keys1, keys2)) {
            return false;
        }
        if (type == null) {
            for (class_9331 key : keys1) {
                if (Objects.equals(tag1.method_57829(key), tag2.method_57829(key))) continue;
                return false;
            }
            return true;
        }
        return Objects.equals(tag1.method_57829(type), tag2.method_57829(type));
    }

    public static boolean areNbtEqualIgnoreKeys(@Nonnull class_2487 tag1, @Nonnull class_2487 tag2, @Nullable Set<String> ignoredKeys) {
        Set keys1 = tag1.method_10541();
        Set keys2 = tag2.method_10541();
        if (ignoredKeys != null) {
            keys1.removeAll(ignoredKeys);
            keys2.removeAll(ignoredKeys);
        }
        if (!Objects.equals(keys1, keys2)) {
            return false;
        }
        for (String key : keys1) {
            if (Objects.equals(tag1.method_10580(key), tag2.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    public static void swapSlots(class_1703 container, int slotNum, int hotbarSlot) {
        class_310 mc = class_310.method_1551();
        mc.field_1761.method_2906(container.field_7763, slotNum, hotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(class_1703 containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.field_7761.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)containerPlayer.field_7761.get(slotNum);
            class_1799 stackSlot = slot.method_7677();
            if (!stackSlot.method_7960() || !InventoryUtils.isRegularInventorySlot(slot.field_7874, allowOffhand)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static int findSlotWithItem(class_1703 container, class_1799 stackReference, boolean reverse) {
        int startSlot = reverse ? container.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_7761.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof class_1723;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)container.field_7761.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.field_7874, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.method_7677(), stackReference)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(class_1799 stackReference, class_310 mc) {
        class_746 player = mc.field_1724;
        boolean isCreative = player.method_7337();
        if (InventoryUtils.areStacksEqualIgnoreNbt(stackReference, player.method_6047())) {
            return false;
        }
        if (isCreative) {
            player.method_31548().method_65126(stackReference);
            mc.field_1761.method_2909(player.method_6047(), 36 + player.method_31548().field_7545);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem((class_1703)player.field_7498, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.method_31548().field_7545;
            mc.field_1761.method_2906(player.field_7498.field_7763, slot, currentHotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
            return true;
        }
        return false;
    }

    @Nullable
    public static class_1263 getInventory(class_1937 world, class_2338 pos) {
        boolean isLoaded = world.method_22340(pos);
        if (!isLoaded) {
            return null;
        }
        class_2586 te = world.method_8500(pos).method_8321(pos);
        if (te instanceof class_1263) {
            class_2338 posAdj;
            boolean isLoadedAdj;
            class_2745 type;
            class_1263 inv = (class_1263)te;
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() instanceof class_2281 && te instanceof class_2595 && (type = (class_2745)state.method_11654((class_2769)class_2281.field_10770)) != class_2745.field_12569 && (isLoadedAdj = world.method_22340(posAdj = pos.method_10093(class_2281.method_9758((class_2680)state))))) {
                class_2680 stateAdj = world.method_8320(posAdj);
                class_2586 te2 = world.method_8500(posAdj).method_8321(posAdj);
                if (stateAdj.method_26204() == state.method_26204() && te2 instanceof class_2595 && stateAdj.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569 && stateAdj.method_11654((class_2769)class_2281.field_10768) == state.method_11654((class_2769)class_2281.field_10768)) {
                    class_1263 invRight = type == class_2745.field_12571 ? inv : (class_1263)te2;
                    class_1263 invLeft = type == class_2745.field_12571 ? (class_1263)te2 : inv;
                    inv = new class_1258(invRight, invLeft);
                }
            }
            return inv;
        }
        return null;
    }

    public static boolean shulkerBoxHasItems(class_1799 stack) {
        class_9288 container = (class_9288)stack.method_57353().method_57829(class_9334.field_49622);
        if (container != null) {
            return container.method_59714().iterator().hasNext();
        }
        return false;
    }

    @Nullable
    public static class_2487 stackHasNbtItems(class_1799 stack, @Nonnull class_5455 registry) {
        class_2487 nbt;
        if (!stack.method_7960() && InventoryUtils.hasNbtItems(nbt = (class_2487)stack.method_57358((class_7225.class_7874)registry))) {
            return nbt;
        }
        return null;
    }

    public static boolean hasNbtItems(class_2487 nbt) {
        if (nbt.method_10573("Items", 10)) {
            class_2499 tagList = nbt.method_10554("Items", 10);
            return !tagList.isEmpty();
        }
        if (nbt.method_10573("Inventory", 9)) {
            class_2499 tagList = nbt.method_10554("Inventory", 10);
            return !tagList.isEmpty();
        }
        if (nbt.method_10573("EnderItems", 9)) {
            class_2499 tagList = nbt.method_10554("EnderItems", 10);
            return !tagList.isEmpty();
        }
        if (nbt.method_10545("item")) {
            return true;
        }
        if (nbt.method_10545("Item")) {
            return true;
        }
        if (nbt.method_10545("Book")) {
            return true;
        }
        return nbt.method_10545("RecordItem");
    }

    public static class_2371<class_1799> getNbtItems(@Nonnull class_2487 tag) {
        if (class_310.method_1551().field_1687 == null) {
            return class_2371.method_10211();
        }
        return InventoryUtils.getNbtItems(tag, -1, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
    }

    public static class_2371<class_1799> getNbtItems(@Nonnull class_2487 nbt, int slotCount, @Nonnull class_7225.class_7874 registry) {
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.method_10573("Items", 10)) {
            class_2499 list = nbt.method_10554("Items", 10);
            if (slotCount < 0) {
                slotCount = list.size();
            }
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt, (class_2371)items, (class_7225.class_7874)registry);
            return items;
        }
        if (nbt.method_10573("Inventory", 9)) {
            class_2499 list = nbt.method_10554("Inventory", 10);
            if (slotCount < 0) {
                slotCount = list.size();
            }
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            for (int i = 0; i < list.size(); ++i) {
                int index = i;
                class_1799.method_57360((class_7225.class_7874)registry, (class_2520)list.method_10602(i)).ifPresent(itemStack -> items.set(index, itemStack));
            }
            return items;
        }
        if (nbt.method_10573("EnderItems", 9)) {
            class_2499 list = nbt.method_10554("EnderItems", 10);
            if (slotCount < 0) {
                slotCount = 27;
            }
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            for (int i = 0; i < list.size(); ++i) {
                class_2487 entry = list.method_10602(i);
                int slot = entry.method_10571("Slot") & 0xFF;
                if (slot >= items.size()) continue;
                items.set(slot, (Object)class_1799.method_57360((class_7225.class_7874)registry, (class_2520)entry).orElse(class_1799.field_8037));
            }
            return items;
        }
        if (nbt.method_10545("item")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("item"));
            class_2371 items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
            items.add(0, (Object)entry);
            return items;
        }
        if (nbt.method_10545("Item")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Item"));
            class_2371 items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
            items.add(0, (Object)entry);
            return items;
        }
        if (nbt.method_10545("Book")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Book"));
            class_2371 items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
            items.add(0, (Object)entry);
            return items;
        }
        if (nbt.method_10545("RecordItem")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("RecordItem"));
            class_2371 items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
            items.add(0, (Object)entry);
            return items;
        }
        return class_2371.method_10211();
    }

    public static class_1263 getNbtInventory(@Nonnull class_2487 nbt) {
        if (class_310.method_1551().field_1687 == null) {
            return null;
        }
        return InventoryUtils.getNbtInventory(nbt, -1, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
    }

    public static class_1263 getNbtInventory(@Nonnull class_2487 nbt, int slotCount, @Nonnull class_7225.class_7874 registry) {
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.method_10545("Items")) {
            if (slotCount < 0) {
                class_2499 list = nbt.method_10554("Items", 10);
                slotCount = list.size();
            }
            class_1277 inv = new class_1277(slotCount);
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt, (class_2371)items, (class_7225.class_7874)registry);
            if (items.isEmpty()) {
                return null;
            }
            for (int i = 0; i < slotCount; ++i) {
                inv.method_5447(i, ((class_1799)items.get(i)).method_7972());
            }
            return inv;
        }
        if (nbt.method_10545("Inventory")) {
            if (slotCount < 0) {
                class_2499 list = nbt.method_10554("Inventory", 10);
                slotCount = list.size();
            }
            class_1277 inv = new class_1277(slotCount);
            inv.method_7659(nbt.method_10554("Inventory", 10), registry);
            if (inv.method_5442()) {
                return null;
            }
            return inv;
        }
        if (nbt.method_10545("EnderItems")) {
            if (slotCount < 0) {
                class_2499 list = nbt.method_10554("EnderItems", 10);
                slotCount = list.size();
            }
            class_1277 inv = new class_1277(slotCount);
            inv.method_7659(nbt.method_10554("EnderItems", 10), registry);
            if (inv.method_5442()) {
                return null;
            }
            return inv;
        }
        if (nbt.method_10545("item")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("item"));
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, entry.method_7972());
            return inv;
        }
        if (nbt.method_10545("Item")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Item"));
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, entry.method_7972());
            return inv;
        }
        if (nbt.method_10545("Book")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("Book"));
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, entry.method_7972());
            return inv;
        }
        if (nbt.method_10545("RecordItem")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("RecordItem"));
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, entry.method_7972());
            return inv;
        }
        return null;
    }

    public static class_1263 getNbtInventoryHorseFix(@Nonnull class_2487 nbt, int slotCount, @Nonnull class_7225.class_7874 registry) {
        class_1799 saddle = class_1799.field_8037;
        if (slotCount > 256) {
            slotCount = 256;
        }
        if (nbt.method_10545("SaddleItem")) {
            saddle = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("SaddleItem"));
        }
        if (nbt.method_10545("Items")) {
            if (slotCount < 0) {
                class_2499 list = nbt.method_10554("Items", 10);
                slotCount = list.size();
            }
            class_1277 inv = new class_1277(slotCount + 1);
            class_2371 items = class_2371.method_10213((int)slotCount, (Object)class_1799.field_8037);
            class_1262.method_5429((class_2487)nbt, (class_2371)items, (class_7225.class_7874)registry);
            if (items.isEmpty()) {
                return null;
            }
            inv.method_5447(0, saddle.method_7972());
            for (int i = 0; i < slotCount; ++i) {
                inv.method_5447(i + 1, (class_1799)items.get(i));
            }
            return inv;
        }
        if (!saddle.method_7960()) {
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, saddle.method_7972());
            return inv;
        }
        if (nbt.method_10545("item")) {
            class_1799 entry = class_1799.method_57359((class_7225.class_7874)registry, (class_2487)nbt.method_10562("item"));
            class_1277 inv = new class_1277(1);
            inv.method_5447(0, entry.method_7972());
        }
        return null;
    }

    @Nullable
    public static class_1730 getPlayerEnderItems(class_1657 player) {
        if (player != null) {
            return ((IMixinPlayerEntity)player).malilib_getEnderItems();
        }
        return null;
    }

    @Nullable
    public static class_1730 getPlayerEnderItemsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_7225.class_7874 registry) {
        if (nbt.method_10573("EnderItems", 9)) {
            class_1730 inv = new class_1730();
            inv.method_7659(nbt.method_10554("EnderItems", 10), registry);
            return inv;
        }
        return null;
    }

    public static class_2371<class_1799> getSellingItemsFromNbt(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) {
        class_1916 offers = NbtEntityUtils.getTradeOffersFromNbt(nbt, registry);
        if (offers != null) {
            return InventoryUtils.getSellingItems(offers);
        }
        return class_2371.method_10211();
    }

    public static class_2371<class_1799> getSellingItems(@Nonnull class_1916 offers) {
        if (!offers.isEmpty()) {
            class_2371 result = class_2371.method_10211();
            for (int i = 0; i < offers.size(); ++i) {
                class_1914 entry = (class_1914)offers.get(i);
                if (entry == null) continue;
                class_1799 sellItem = entry.method_8250();
                result.add((Object)sellItem.method_7972());
            }
            return result;
        }
        return class_2371.method_10211();
    }

    public static class_2371<class_1799> getStoredItems(class_1799 stackIn) {
        class_9288 container = (class_9288)stackIn.method_57353().method_57829(class_9334.field_49622);
        if (container != null) {
            Iterator iter = container.method_59712().iterator();
            class_2371 items = class_2371.method_37434((int)((int)container.method_59712().count()));
            int i = 0;
            while (iter.hasNext()) {
                items.add((Object)((class_1799)iter.next()).method_7972());
                ++i;
            }
            return items;
        }
        return class_2371.method_10211();
    }

    public static class_2371<class_1799> getStoredItems(class_1799 stackIn, int slotCount) {
        class_9288 itemContainer = (class_9288)stackIn.method_57353().method_57829(class_9334.field_49622);
        if (itemContainer != null) {
            long defSlotCount = itemContainer.method_57489().count();
            slotCount = slotCount < 1 ? (defSlotCount < 256L ? (int)defSlotCount : 256) : Math.min(slotCount, 256);
            class_2371 items = class_2371.method_37434((int)slotCount);
            Iterator iter = itemContainer.method_57489().iterator();
            for (int i = 0; i < slotCount; ++i) {
                class_1799 entry = iter.hasNext() ? (class_1799)iter.next() : class_1799.field_8037;
                items.add((Object)entry.method_7972());
            }
            return items;
        }
        return class_2371.method_10211();
    }

    public static boolean bundleHasItems(class_1799 stack) {
        class_9276 bundleContainer = (class_9276)stack.method_57353().method_57829(class_9334.field_49650);
        if (bundleContainer != null) {
            return !bundleContainer.method_57429();
        }
        return false;
    }

    public static Fraction bundleOccupancy(class_1799 stack) {
        class_9276 bundleContainer = (class_9276)stack.method_57353().method_57829(class_9334.field_49650);
        if (bundleContainer != null) {
            return bundleContainer.method_57428();
        }
        return Fraction.ZERO;
    }

    public static int bundleCountItems(class_1799 stack) {
        class_9276 bundleContainer = (class_9276)stack.method_57353().method_57829(class_9334.field_49650);
        if (bundleContainer != null) {
            return bundleContainer.method_57426();
        }
        return -1;
    }

    public static class_2371<class_1799> getBundleItems(class_1799 stackIn) {
        class_9276 bundleContainer = (class_9276)stackIn.method_57353().method_57830(class_9334.field_49650, (Object)class_9276.field_49289);
        if (bundleContainer != null && !bundleContainer.equals((Object)class_9276.field_49289)) {
            int maxSlots = bundleContainer.method_57426();
            class_2371 items = class_2371.method_37434((int)maxSlots);
            Iterator iter = bundleContainer.method_59707().iterator();
            while (iter.hasNext()) {
                class_1799 slot = (class_1799)iter.next();
                if (slot.method_7960()) continue;
                items.add((Object)slot.method_7972());
            }
            return items;
        }
        return class_2371.method_10211();
    }

    public static class_2371<class_1799> getBundleItems(class_1799 stackIn, int maxSlots) {
        class_9276 bundleContainer = (class_9276)stackIn.method_57353().method_57830(class_9334.field_49650, (Object)class_9276.field_49289);
        if (bundleContainer != null && !bundleContainer.equals((Object)class_9276.field_49289)) {
            int defMaxSlots = bundleContainer.method_57426();
            maxSlots = maxSlots < 1 ? defMaxSlots : (maxSlots < 64 ? maxSlots : defMaxSlots);
            class_2371 items = class_2371.method_37434((int)maxSlots);
            Iterator iter = bundleContainer.method_59707().iterator();
            for (int limit = 0; iter.hasNext() && limit < maxSlots; ++limit) {
                items.add((Object)((class_1799)iter.next()).method_7972());
            }
            return items;
        }
        return class_2371.method_10211();
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(class_1799 stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        class_2371<class_1799> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (class_1799 stack : items) {
            if (stack.method_7960()) continue;
            map.addTo((Object)new ItemType(stack), stack.method_7947());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(class_1263 inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.method_5439();
        for (int slot = 0; slot < slots; ++slot) {
            class_1799 stack = inv.method_5438(slot);
            if (stack.method_7960()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.method_7947());
            if (!(stack.method_7909() instanceof class_1747) || !(((class_1747)stack.method_7909()).method_7711() instanceof class_2480)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static class_2371<class_1799> getAsItemList(class_1263 inv) {
        if (inv == null || inv.method_5442()) {
            return class_2371.method_10211();
        }
        int size = inv.method_5439();
        class_2371 list = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        for (int i = 0; i < size; ++i) {
            class_1799 entry = inv.method_5438(i);
            if (entry.method_7960()) continue;
            list.set(i, (Object)entry.method_7972());
        }
        return list;
    }

    @Nullable
    public static class_1263 getAsInventory(class_2371<class_1799> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        class_1277 inv = new class_1277(items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.method_5447(slot, ((class_1799)items.get(slot)).method_7972());
        }
        return inv;
    }

    @Nullable
    public static class_1799 getItemStackFromString(String itemNameIn) {
        return InventoryUtils.getItemStackFromString(itemNameIn, -1, class_9323.field_49584);
    }

    @Nullable
    public static class_1799 getItemStackFromString(String itemNameIn, class_9323 data) {
        return InventoryUtils.getItemStackFromString(itemNameIn, -1, data);
    }

    @Nullable
    public static class_1799 getItemStackFromString(String itemNameIn, int count) {
        return InventoryUtils.getItemStackFromString(itemNameIn, count, class_9323.field_49584);
    }

    @Nullable
    public static class_1799 getItemStackFromString(String itemNameIn, int count, @Nonnull class_9323 data) {
        String itemName;
        if (itemNameIn.isEmpty() || itemNameIn.equals("empty") || itemNameIn.equals("minecraft:air") || itemNameIn.equals("air")) {
            return class_1799.field_8037;
        }
        Matcher matcherBase = PATTERN_ITEM_BASE.matcher(itemNameIn);
        if (matcherBase.matches() && (itemName = matcherBase.group("name")) != null) {
            class_2960 itemId = class_2960.method_12829((String)itemName);
            class_6880 itemEntry = class_7923.field_41178.method_10223(itemId).orElse(null);
            if (itemEntry != null && itemEntry.method_40227()) {
                class_1799 stackOut = count < 0 ? new class_1799(itemEntry) : new class_1799(itemEntry, count);
                if (!data.method_57837() && !data.equals((Object)class_9323.field_49584)) {
                    stackOut.method_57365(data);
                }
                return stackOut;
            }
            MaLiLib.LOGGER.warn(StringUtils.translate("malilib.error.invalid_item_stack_entry.string", itemName));
        }
        return null;
    }

    @Nullable
    public static class_1799 getItemStackFromString(String stringIn, @Nonnull class_5455 registry) {
        class_2291.class_7215 results;
        class_2291 itemStringReader = new class_2291((class_7225.class_7874)registry);
        try {
            results = itemStringReader.method_9789(new StringReader(stringIn));
        }
        catch (CommandSyntaxException e) {
            MaLiLib.LOGGER.warn(StringUtils.translate("malilib.error.invalid_item_stack_entry.nbt_syntax", stringIn));
            return null;
        }
        class_1799 stackOut = new class_1799(results.comp_628());
        stackOut.method_59692(results.comp_2439());
        return stackOut;
    }

    public static class_6880<class_1792> getItemEntry(class_2960 id, @Nonnull class_5455 registry) {
        try {
            return (class_6880)registry.method_30530(class_7923.field_41178.method_46765()).method_10223(id).orElseThrow();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean hasStoredBlockEntityData(class_1799 stack) {
        return stack.method_57826(class_9334.field_49611);
    }

    public static class_2487 getStoredBlockEntityNbt(class_1799 stack) {
        class_9279 component;
        if (stack.method_57826(class_9334.field_49611) && (component = (class_9279)stack.method_57824(class_9334.field_49611)) != null) {
            return component.method_57461();
        }
        return new class_2487();
    }
}

