/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiKeybindSettings;
import fi.dy.masa.malilib.gui.interfaces.IDialogHandler;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class WidgetKeybindSettings
extends WidgetBase {
    public static final class_2960 TEXTURE = class_2960.method_60655((String)"malilib", (String)"textures/gui/gui_widgets.png");
    protected final String keybindName;
    protected final IKeybind keybind;
    protected final KeybindSettings settings;
    protected final WidgetListBase<?, ?> widgetList;
    @Nullable
    protected final IDialogHandler dialogHandler;

    public WidgetKeybindSettings(int x, int y, int width, int height, IKeybind keybind, String keybindName, WidgetListBase<?, ?> widgetList, @Nullable IDialogHandler dialogHandler) {
        super(x, y, width, height);
        this.keybind = keybind;
        this.keybindName = keybindName;
        this.settings = keybind.getSettings();
        this.widgetList = widgetList;
        this.dialogHandler = dialogHandler;
    }

    @Override
    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0) {
            if (this.dialogHandler != null) {
                this.dialogHandler.openDialog(new GuiKeybindSettings(this.keybind, this.keybindName, this.dialogHandler, GuiUtils.getCurrentScreen()));
            } else {
                GuiBase.openGui(new GuiKeybindSettings(this.keybind, this.keybindName, null, GuiUtils.getCurrentScreen()));
            }
            return true;
        }
        if (mouseButton == 1) {
            this.keybind.resetSettingsToDefaults();
            this.widgetList.refreshEntries();
            return true;
        }
        return false;
    }

    @Override
    public void render(int mouseX, int mouseY, boolean selected, class_332 drawContext) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        this.bindTexture(TEXTURE);
        int w = 18;
        int v1 = this.settings.getActivateOn().ordinal() * w;
        int v2 = !this.settings.getAllowExtraKeys() ? w : 0;
        int v3 = this.settings.isOrderSensitive() ? w : 0;
        int v4 = this.settings.isExclusive() ? w : 0;
        int v5 = this.settings.shouldCancel() ? w : 0;
        int x = this.x;
        int y = this.y;
        int edgeColor = this.keybind.areSettingsModified() ? -17613 : -1;
        RenderSystem.enableDepthTest();
        RenderUtils.drawRect(x, y + 0, 20, 20, edgeColor);
        RenderUtils.drawRect(x + 1, y + 1, 18, 18, -16777216);
        RenderSystem.disableDepthTest();
        RenderUtils.forceDraw(drawContext);
        float z = 0.0f;
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectAndDraw(TEXTURE, ++x, ++y, 0, v1, w, w, z, drawContext);
        RenderUtils.drawTexturedRectAndDraw(TEXTURE, x, y, 18, v2, w, w, z, drawContext);
        RenderUtils.drawTexturedRectAndDraw(TEXTURE, x, y, 36, v3, w, w, z, drawContext);
        RenderUtils.drawTexturedRectAndDraw(TEXTURE, x, y, 54, v4, w, w, z, drawContext);
        RenderUtils.drawTexturedRectAndDraw(TEXTURE, x, y, 72, v5, w, w, z, drawContext);
        RenderSystem.disableDepthTest();
    }

    @Override
    public void postRenderHovered(int mouseX, int mouseY, boolean selected, class_332 drawContext) {
        ArrayList<String> text = new ArrayList<String>();
        String strYes = StringUtils.translate("malilib.gui.label.yes", new Object[0]);
        String strNo = StringUtils.translate("malilib.gui.label.no", new Object[0]);
        text.add(GuiBase.TXT_WHITE + GuiBase.TXT_UNDERLINE + StringUtils.translate("malilib.gui.label.keybind_settings.title_advanced_keybind_settings", new Object[0]));
        String name = StringUtils.translate("malilib.gui.label.keybind_settings.activate_on", new Object[0]);
        String val = GuiBase.TXT_BLUE + this.settings.getActivateOn().name();
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.allow_empty_keybind", new Object[0]);
        val = this.settings.getAllowEmpty() ? GuiBase.TXT_GREEN + strYes : GuiBase.TXT_GOLD + strNo;
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.allow_extra_keys", new Object[0]);
        val = this.settings.getAllowExtraKeys() ? GuiBase.TXT_GREEN + strYes : GuiBase.TXT_GOLD + strNo;
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.order_sensitive", new Object[0]);
        val = this.settings.isOrderSensitive() ? GuiBase.TXT_GOLD + strYes : GuiBase.TXT_GREEN + strNo;
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.cancel_further", new Object[0]);
        val = this.settings.shouldCancel() ? GuiBase.TXT_GOLD + strYes : GuiBase.TXT_GREEN + strNo;
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.exclusive", new Object[0]);
        val = this.settings.isExclusive() ? GuiBase.TXT_GOLD + strYes : GuiBase.TXT_GREEN + strNo;
        text.add(String.format("%s: %s", name, val));
        name = StringUtils.translate("malilib.gui.label.keybind_settings.context", new Object[0]);
        val = GuiBase.TXT_BLUE + this.settings.getContext().name();
        text.add(String.format("%s: %s", name, val));
        text.add("");
        String[] parts = StringUtils.translate("malilib.gui.label.keybind_settings.tips", new Object[0]).split("\\n");
        for (int i = 0; i < parts.length; ++i) {
            text.add(parts[i]);
        }
        RenderUtils.drawHoverText(mouseX + 10, mouseY, text, drawContext);
        RenderUtils.forceDraw(drawContext);
    }
}

