/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.item;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.LambDynLightsConstants;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSource;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.LightSourceLoader;
import dev.lambdaurora.lambdynlights.resource.LoadedLightSourceResource;
import dev.yumi.commons.event.Event;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ItemLightSources
extends LightSourceLoader<ItemLightSource>
implements ItemLightSourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|ItemLightSources");
    public static final class_2960 RESOURCE_RELOADER_ID = LambDynLightsConstants.id("item_dynamic_lights");
    private final Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent = LambDynLights.EVENT_MANAGER.create(ItemLightSourceManager.OnRegister.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public class_2960 getFabricId() {
        return RESOURCE_RELOADER_ID;
    }

    @Override
    protected String getResourcePath() {
        return "item";
    }

    @Override
    public void apply(final class_5455 registryAccess) {
        super.apply(registryAccess);
        this.onRegisterEvent.invoker().onRegister(new ItemLightSourceManager.RegisterContext(){

            @NotNull
            public class_5455 registryAccess() {
                return registryAccess;
            }

            public void register(@NotNull ItemLightSource itemLightSource) {
                ItemLightSources.this.lightSources.add(itemLightSource);
            }
        });
    }

    @Override
    protected void apply(DynamicOps<JsonElement> ops, LoadedLightSourceResource loadedData) {
        DataResult loaded = ItemLightSource.CODEC.parse(ops, (Object)loadedData.data());
        if (!loadedData.silenceError() || LambDynLightsConstants.FORCE_LOG_ERRORS) {
            loaded.ifError(error -> LambDynLights.warn(LOGGER, "Failed to load item light source \"{}\" due to error: {}", loadedData.id(), error.message()));
        }
        loaded.ifSuccess(this.lightSources::add);
    }

    @NotNull
    public Event<class_2960, ItemLightSourceManager.OnRegister> onRegisterEvent() {
        return this.onRegisterEvent;
    }

    public int getLuminance(@NotNull class_1799 stack, boolean submergedInWater) {
        boolean shouldCareAboutWater = submergedInWater && (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get() != false;
        int luminance = 0;
        boolean matchedAny = false;
        for (ItemLightSource data : this.lightSources) {
            if (!data.predicate().method_8970(stack)) continue;
            matchedAny = true;
            if (shouldCareAboutWater && data.waterSensitive()) continue;
            luminance = Math.max(luminance, data.getLuminance(stack));
        }
        if (!matchedAny) {
            luminance = class_2248.method_9503((class_1792)stack.method_7909()).method_9564().method_26213();
        }
        return luminance;
    }
}

