/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.resource.entity.luminance;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.resource.entity.EntityLightSources;
import java.util.List;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record WetSensititiveEntityLuminance(List<EntityLuminance> dry, List<EntityLuminance> wet) implements EntityLuminance
{
    public static final MapCodec<WetSensititiveEntityLuminance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EntityLuminance.LIST_CODEC.optionalFieldOf("dry", List.of()).forGetter(WetSensititiveEntityLuminance::dry), (App)EntityLuminance.LIST_CODEC.optionalFieldOf("wet", List.of()).forGetter(WetSensititiveEntityLuminance::wet)).apply((Applicative)instance, WetSensititiveEntityLuminance::new));

    @NotNull
    public EntityLuminance.Type type() {
        return EntityLightSources.WET_SENSITIVE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
        boolean submergedInWater = entity.method_5637();
        boolean shouldCareAboutWater = (Boolean)LambDynLights.get().config.getWaterSensitiveCheck().get();
        if (submergedInWater && (shouldCareAboutWater || this.dry.isEmpty())) {
            return EntityLuminance.getLuminance((ItemLightSourceManager)itemLightSourceManager, (class_1297)entity, this.wet);
        }
        return EntityLuminance.getLuminance((ItemLightSourceManager)itemLightSourceManager, (class_1297)entity, this.dry);
    }
}

