/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.gui;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.ExplosiveLightingMode;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.accessor.DynamicLightHandlerHolder;
import dev.lambdaurora.lambdynlights.gui.InnerBackground;
import dev.lambdaurora.lambdynlights.gui.LightSourceListWidget;
import dev.lambdaurora.lambdynlights.gui.RandomPrideFlagBackground;
import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextFieldWidget;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends SpruceScreen {
    private static final Background INNER_BACKGROUND = new InnerBackground();
    private static final String DYNAMIC_LIGHT_SOURCES_KEY = "lambdynlights.menu.light_sources";
    private static final String SPECIAL_DYNAMIC_LIGHT_SOURCES_KEY = "lambdynlights.menu.light_sources.special";
    private static final String ADVANCED_KEY = "lambdynlights.menu.advanced";
    private final DynamicLightsConfig config;
    private final class_437 parent;
    private final SpruceOption entitiesOption;
    private final SpruceOption selfOption;
    private final SpruceOption waterSensitiveOption;
    private final SpruceOption creeperLightingOption;
    private final SpruceOption tntLightingOption;
    private final SpruceOption debugCellDisplayRadiusOption;
    private final SpruceOption debugLightLevelRadiusOption;
    private final SpruceOption resetOption;
    private SpruceTabbedWidget tabbedWidget;
    private SpruceTextFieldWidget searchInput;

    public SettingsScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"lambdynlights.menu.title"));
        this.parent = parent;
        this.config = LambDynLights.get().config;
        this.entitiesOption = this.config.getEntitiesLightSource().getOption();
        this.selfOption = this.config.getSelfLightSource().getOption();
        this.waterSensitiveOption = this.config.getWaterSensitiveCheck().getOption();
        this.creeperLightingOption = new SpruceCyclingOption("entity.minecraft.creeper", amount -> this.config.setCreeperLightingMode(this.config.getCreeperLightingMode().next()), option -> option.getDisplayText(this.config.getCreeperLightingMode().getTranslatedText()), (class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.creeper_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.tntLightingOption = new SpruceCyclingOption("block.minecraft.tnt", amount -> this.config.setTntLightingMode(this.config.getTntLightingMode().next()), option -> option.getDisplayText(this.config.getTntLightingMode().getTranslatedText()), (class_2561)class_2561.method_43469((String)"lambdynlights.tooltip.tnt_lighting", (Object[])new Object[]{ExplosiveLightingMode.OFF.getTranslatedText(), ExplosiveLightingMode.SIMPLE.getTranslatedText(), ExplosiveLightingMode.FANCY.getTranslatedText()}));
        this.debugCellDisplayRadiusOption = new SpruceDoubleOption("lambdynlights.option.debug.cell_display_radius", 0.0, 10.0, 1.0f, () -> this.config.getDebugCellDisplayRadius(), value -> this.config.setDebugCellDisplayRadius(value.intValue()), option -> option.getDisplayText((class_2561)(option.get() <= 0.0 ? SpruceTexts.OPTIONS_OFF.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)String.format("%.0f", option.get())))), null);
        this.debugLightLevelRadiusOption = new SpruceDoubleOption("lambdynlights.option.debug.light_level_radius", 0.0, 10.0, 1.0f, () -> this.config.getDebugLightLevelRadius(), value -> this.config.setDebugLightLevelRadius(value.intValue()), option -> option.getDisplayText((class_2561)(option.get() <= 0.0 ? SpruceTexts.OPTIONS_OFF.method_27661().method_27692(class_124.field_1061) : class_2561.method_43470((String)String.format("%.0f", option.get())))), null);
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            this.config.reset();
            class_310 client = class_310.method_1551();
            this.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
        });
    }

    public void method_25432() {
        super.method_25432();
        this.config.save();
    }

    private int getTextHeight() {
        Objects.requireNonNull(this.field_22793);
        return (5 + 9) * 3 + 5;
    }

    protected void method_25426() {
        Object e;
        super.method_25426();
        class_5250 dynamicLightSources = class_2561.method_43471((String)DYNAMIC_LIGHT_SOURCES_KEY);
        int tabIndex = 0;
        if (this.tabbedWidget != null) {
            SpruceTabbedWidget.TabEntry oldEntry = this.tabbedWidget.getList().getCurrentTab();
            tabIndex = this.tabbedWidget.getList().children().indexOf(oldEntry);
        }
        this.tabbedWidget = new SpruceTabbedWidget(Position.origin(), this.field_22789, this.field_22790, (class_2561)this.field_22785.method_27661(), Math.max(100, this.field_22789 / 8));
        this.tabbedWidget.getList().setBackground(RandomPrideFlagBackground.random());
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.general"), null, this.tabContainerBuilder(this::buildGeneralTab));
        this.tabbedWidget.addSeparatorEntry(null);
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43473().method_10852((class_2561)dynamicLightSources).method_27693(": ").method_10852(this.entitiesOption.getPrefix()), null, this.tabContainerBuilder(this::buildEntitiesTab));
        this.tabbedWidget.addSeparatorEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.advanced"));
        this.tabbedWidget.addTabEntry((class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.debug"), (class_2561)class_2561.method_43471((String)"lambdynlights.menu.tabs.debug.description").method_27692(class_124.field_1080), this.tabContainerBuilder(this::buildDebugTab));
        this.method_25429((class_364)this.tabbedWidget);
        if (tabIndex > 0 && (e = this.tabbedWidget.getList().children().get(tabIndex)) instanceof SpruceTabbedWidget.TabEntry) {
            SpruceTabbedWidget.TabEntry tabEntry = (SpruceTabbedWidget.TabEntry)e;
            this.tabbedWidget.getList().setSelected(tabEntry);
        }
    }

    private SpruceTabbedWidget.ContainerFactory tabContainerBuilder(Consumer<TabContext> innerFactory) {
        return (width, height) -> this.buildTabContainer(width, height, innerFactory);
    }

    private SpruceContainerWidget buildTabContainer(int width, int height, Consumer<TabContext> tabConsumer) {
        SpruceContainerWidget container = new SpruceContainerWidget(Position.origin(), width, height);
        tabConsumer.accept(new TabContext(this.tabbedWidget, container, height - this.tabbedWidget.getList().getPosition().getRelativeY() - 40));
        container.addChild(this.resetOption.createWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155), (int)(height - 29)), 150));
        container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(width / 2 - 155 + 160), (int)(height - 29)), 150, 20, SpruceTexts.GUI_DONE, btn -> this.field_22787.method_1507(this.parent)));
        return container;
    }

    private void buildGeneralTab(TabContext context) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.of((int)0, (int)0), context.width(), context.height());
        list.addSingleOptionEntry(this.config.dynamicLightsModeOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(DYNAMIC_LIGHT_SOURCES_KEY, true, null));
        list.addOptionEntry(this.entitiesOption, this.selfOption);
        list.addSingleOptionEntry(this.waterSensitiveOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption(SPECIAL_DYNAMIC_LIGHT_SOURCES_KEY, true, null));
        list.addOptionEntry(this.creeperLightingOption, this.tntLightingOption);
        list.addOptionEntry(this.config.getBeamLighting().getOption(), this.config.getGuardianLaser().getOption());
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildDebugTab(TabContext context) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.of((int)0, (int)0), context.width(), context.height());
        list.addSingleOptionEntry(this.config.getDebugActiveDynamicLightingCells().getOption());
        list.addSingleOptionEntry(this.debugCellDisplayRadiusOption);
        list.addSingleOptionEntry(this.config.getDebugDisplayDynamicLightingChunkRebuilds().getOption());
        list.addSingleOptionEntry(this.debugLightLevelRadiusOption);
        list.addSingleOptionEntry(this.config.getDebugDisplayHandlerBoundingBox().getOption());
        context.addInnerWidget((SpruceParentWidget<?>)list);
    }

    private void buildEntitiesTab(TabContext context) {
        this.buildLightSourcesTab(context, class_7923.field_41177.method_10220().map(DynamicLightHandlerHolder::cast).collect(Collectors.toList()));
    }

    private void buildLightSourcesTab(TabContext context, List<DynamicLightHandlerHolder<?>> entries) {
        String oldSearch = this.searchInput != null ? this.searchInput.getText() : "";
        this.searchInput = context.addSearchInput();
        LightSourceListWidget list = new LightSourceListWidget(Position.of((int)0, (int)0), context.width(), context.height(), this.searchInput);
        list.addAll(entries);
        context.addInnerWidget((SpruceParentWidget<?>)list);
        this.searchInput.setText(oldSearch);
    }

    record TabContext(SpruceTabbedWidget tabbedWidget, SpruceContainerWidget container, int height) {
        int width() {
            return this.container().getWidth();
        }

        SpruceTextFieldWidget addSearchInput() {
            class_5250 searchText = class_2561.method_43471((String)"lambdynlights.menu.search");
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)searchText);
            int searchInputX = this.width() - 140;
            this.container.addChild((SpruceWidget)new SpruceLabelWidget(Position.of((int)(searchInputX - 4 - textWidth), (int)8), (class_2561)searchText, textWidth));
            SpruceTextFieldWidget searchInput = SpruceTextFieldWidget.builder((Position)Position.of((int)searchInputX, (int)4), (int)136, (int)20).title((class_2561)class_2561.method_43470((String)"Search")).placeholder((class_2561)class_1299.field_6099.method_5897().method_27661().method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).build();
            this.container().addChild((SpruceWidget)searchInput);
            return searchInput;
        }

        void addInnerWidget(SpruceParentWidget<?> widget) {
            widget.getPosition().setRelativeY(this.tabbedWidget.getList().getPosition().getRelativeY());
            this.container().addChild(widget);
        }
    }
}

