/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.libs.quilt.parsers.json.gson;

import com.google.gson.stream.JsonToken;
import dev.isxander.yacl3.libs.quilt.parsers.json.JsonReader;
import java.io.IOException;
import java.io.Reader;

public class GsonReader
extends com.google.gson.stream.JsonReader {
    private final JsonReader delegate;

    public GsonReader(JsonReader reader) {
        super(Reader.nullReader());
        this.delegate = reader;
    }

    public JsonReader getDelegate() {
        return this.delegate;
    }

    public void beginArray() throws IOException {
        this.delegate.beginArray();
    }

    public void endArray() throws IOException {
        this.delegate.endArray();
    }

    public void beginObject() throws IOException {
        this.delegate.beginObject();
    }

    public void endObject() throws IOException {
        this.delegate.endObject();
    }

    public boolean hasNext() throws IOException {
        return this.delegate.hasNext();
    }

    public JsonToken peek() throws IOException {
        switch (this.delegate.peek()) {
            case BEGIN_ARRAY: {
                return JsonToken.BEGIN_ARRAY;
            }
            case END_ARRAY: {
                return JsonToken.END_ARRAY;
            }
            case BEGIN_OBJECT: {
                return JsonToken.BEGIN_OBJECT;
            }
            case END_OBJECT: {
                return JsonToken.END_OBJECT;
            }
            case NAME: {
                return JsonToken.NAME;
            }
            case STRING: {
                return JsonToken.STRING;
            }
            case NUMBER: {
                return JsonToken.NUMBER;
            }
            case BOOLEAN: {
                return JsonToken.BOOLEAN;
            }
            case NULL: {
                return JsonToken.NULL;
            }
            case END_DOCUMENT: {
                return JsonToken.END_DOCUMENT;
            }
        }
        throw new IllegalArgumentException();
    }

    public String nextName() throws IOException {
        return this.delegate.nextName();
    }

    public String nextString() throws IOException {
        return this.delegate.nextString();
    }

    public boolean nextBoolean() throws IOException {
        return this.delegate.nextBoolean();
    }

    public void nextNull() throws IOException {
        this.delegate.nextNull();
    }

    public double nextDouble() throws IOException {
        return this.delegate.nextDouble();
    }

    public long nextLong() throws IOException {
        return this.delegate.nextLong();
    }

    public int nextInt() throws IOException {
        return this.delegate.nextInt();
    }

    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    public void skipValue() throws IOException {
        this.delegate.skipValue();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String getPreviousPath() {
        return this.delegate.getPreviousPath();
    }

    public String getPath() {
        return this.delegate.getPath();
    }
}

