/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_465;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_8887;
import net.minecraft.class_9304;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(class_310 mc, class_332 drawContext) {
        if (mc.field_1724 == null) {
            return;
        }
        class_746 player = mc.field_1724;
        if (mc.field_1755 == null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            class_327 textRenderer = mc.field_1772;
            Matrix4f modelViewMatrix = new Matrix4f();
            modelViewMatrix.set((Matrix4fc)RenderSystem.getModelViewMatrix());
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.bindTexture((class_2960)class_465.field_2801);
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54);
            drawContext.method_25303(textRenderer, "1", x - 10, y + 4, 0xFFFFFF);
            drawContext.method_25303(textRenderer, "2", x - 10, y + 22, 0xFFFFFF);
            drawContext.method_25303(textRenderer, "3", x - 10, y + 40, 0xFFFFFF);
            for (int row = 1; row <= 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    class_1799 stack = player.method_31548().method_5438(row * 9 + column);
                    if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt((class_1799)stack, (float)x, (float)y, (float)1.0f, (class_310)mc, (class_332)drawContext);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
            RenderSystem.getModelViewMatrix().set((Matrix4fc)modelViewMatrix);
        }
    }

    public static void renderInventoryOverlay(InventoryOverlay.Context context, class_332 drawContext) {
        class_310 mc = class_310.method_1551();
        class_1309 entityLivingBase = null;
        class_2586 be = null;
        class_1263 inv = null;
        class_2487 nbt = new class_2487();
        if (context.be() != null) {
            be = context.be();
        } else if (context.entity() != null && context.entity() instanceof class_1309) {
            entityLivingBase = context.entity();
        }
        if (context.inv() != null) {
            inv = context.inv();
        }
        if (context.nbt() != null) {
            nbt.method_10543(context.nbt());
        }
        boolean isWolf = entityLivingBase instanceof class_1493;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.method_5439() > 0) {
            class_2248 class_22482;
            boolean isHorse = entityLivingBase instanceof class_1496;
            int totalSlots = isHorse ? inv.method_5439() - 1 : inv.method_5439();
            int firstSlot = isHorse ? 1 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType((class_1263)inv, (class_2487)nbt, (InventoryOverlay.Context)context);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            Set lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if (be != null && type == InventoryOverlay.InventoryRenderType.CRAFTER) {
                if (be instanceof class_8887) {
                    class_8887 cbe = (class_8887)be;
                    lockedSlots = BlockUtils.getDisabledSlots((class_8887)cbe);
                } else if (context.nbt() != null) {
                    lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt((class_2487)context.nbt());
                }
            }
            if (context.be() != null && (class_22482 = context.be().method_11010().method_26204()) instanceof class_2480) {
                class_2480 sbb = (class_2480)class_22482;
                fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((class_2480)sbb, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
            if (isHorse) {
                class_1277 horseInv = new class_1277(2);
                class_1799 horseArmor = ((class_1496)entityLivingBase).method_56676();
                horseInv.method_5447(0, horseArmor != null && !horseArmor.method_7960() ? horseArmor : class_1799.field_8037);
                horseInv.method_5447(1, inv.method_5438(0));
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (class_310)mc);
                InventoryOverlay.renderInventoryBackgroundSlots((InventoryOverlay.InventoryRenderType)type, (class_1263)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (class_332)drawContext);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)horseInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (class_310)mc, (class_332)drawContext);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (class_310)mc);
                if (type == InventoryOverlay.InventoryRenderType.BREWING_STAND) {
                    InventoryOverlay.renderBrewerBackgroundSlots((class_1263)inv, (int)xInv, (int)yInv, (class_332)drawContext);
                }
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, lockedSlots, (class_310)mc, (class_332)drawContext);
            }
        }
        if (isWolf) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.HORSE;
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)2);
            int rows = (int)Math.ceil(2.0 / (double)props.slotsPerRow);
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            x = xCenter - 55;
            int xInv = xCenter + 2;
            yInv = Math.min(yInv, yCenter - 92);
            class_1277 wolfInv = new class_1277(2);
            class_1799 wolfArmor = ((class_1493)entityLivingBase).method_56676();
            wolfInv.method_5447(0, wolfArmor != null && !wolfArmor.method_7960() ? wolfArmor : class_1799.field_8037);
            InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (class_310)mc);
            InventoryOverlay.renderWolfArmorBackgroundSlots((class_1263)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (class_332)drawContext);
            InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)wolfInv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (class_310)mc, (class_332)drawContext);
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (class_1309)entityLivingBase, (class_332)drawContext);
            InventoryOverlay.renderEquipmentStacks((class_1309)entityLivingBase, (int)x, (int)y, (class_310)mc, (class_332)drawContext);
        }
    }

    public static void renderPlayerInventoryOverlay(class_310 mc, class_332 drawContext) {
        if (mc.field_1724 == null) {
            return;
        }
        class_1661 inv = mc.field_1724.method_31548();
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27, (class_310)mc, (class_332)drawContext);
    }

    public static void renderHotbarScrollOverlay(class_310 mc, class_332 drawContext) {
        if (mc.field_1724 == null) {
            return;
        }
        class_1661 inv = mc.field_1724.method_31548();
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (class_310)mc);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)(y + 70), (int)9, (int)9, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27, (class_310)mc, (class_332)drawContext);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9, (class_310)mc, (class_332)drawContext);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float getLavaFogDistance(class_1297 entity, float originalFog) {
        class_1309 living;
        class_1799 head;
        if (entity instanceof class_1309 && !(head = (living = (class_1309)entity).method_6118(class_1304.field_6169)).method_7960()) {
            class_9304 enchants = head.method_58657();
            float fog = originalFog > 1.0f ? 3.3f : 1.3f;
            int resp = 0;
            int aqua = 0;
            if (!enchants.equals((Object)class_9304.field_49385)) {
                Set enchantList = enchants.method_57534();
                for (class_6880 entry : enchantList) {
                    if (entry.method_40225(class_1893.field_9105)) {
                        aqua = enchants.method_57536(entry);
                    }
                    if (!entry.method_40225(class_1893.field_9127)) continue;
                    resp = enchants.method_57536(entry);
                }
            }
            if (aqua > 0) {
                fog *= 1.6f;
            }
            if (resp > 0) {
                fog *= (float)resp * 1.6f;
            }
            return Math.max(fog, originalFog);
        }
        return originalFog;
    }

    public static void renderDirectionsCursor(class_332 drawContext) {
        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();
        float width = (float)drawContext.method_51421() / 2.0f;
        float height = (float)drawContext.method_51443() / 2.0f;
        float pitch = camera.method_19329();
        float yaw = camera.method_19330();
        RenderSystem.enableBlend();
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        matrix4fStack.pushMatrix();
        matrix4fStack.mul((Matrix4fc)drawContext.method_51448().method_23760().method_23761());
        matrix4fStack.translate(width, height, 0.0f);
        matrix4fStack.rotateX(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)(-pitch)));
        matrix4fStack.rotateY(fi.dy.masa.malilib.render.RenderUtils.matrix4fRotateFix((float)yaw));
        matrix4fStack.scale(-1.0f, -1.0f, -1.0f);
        RenderSystem.renderCrosshair((int)10);
        matrix4fStack.popMatrix();
        RenderSystem.disableBlend();
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator(class_332 drawContext) {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            class_310 mc = class_310.method_1551();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(xCenter, yCenter, 80, 12, mc, drawContext);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(xCenter, yCenter, 12, 50, mc, drawContext);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(int xCenter, int yCenter, int width, int height, class_310 mc, class_332 drawContext) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = class_3532.method_15367((double)MiscUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = MiscUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(class_3532.method_15338((double)(realYaw - startYaw)) / step * (double)width);
        class_327 textRenderer = mc.field_1772;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        String str = class_3532.method_15338((double)snappedYaw) + "\u00b0";
        drawContext.method_51433(textRenderer, str, xCenter - textRenderer.method_1727(str) / 2, y + height + 2, -1, false);
        str = "<  " + class_3532.method_15338((double)(snappedYaw - step)) + "\u00b0";
        drawContext.method_51433(textRenderer, str, x - textRenderer.method_1727(str), y + height + 2, -1, false);
        str = class_3532.method_15338((double)(snappedYaw + step)) + "\u00b0  >";
        drawContext.method_51433(textRenderer, str, x + width, y + height + 2, -1, false);
        if (Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue();
            int snapThreshOffset = (int)((double)width * threshold / step);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)(snapThreshOffset * 2), (int)height, (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter + snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
            }
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)lineX, (int)y, (int)2, (int)height, (int)-1);
    }

    private static void renderSnapAimAngleIndicatorPitch(int xCenter, int yCenter, int width, int height, class_310 mc, class_332 drawContext) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = class_3532.method_15338((double)MiscUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -MiscUtils.calculateSnappedAngle(-realPitch, step) : MiscUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = class_3532.method_15350((double)class_3532.method_15338((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(x, y, width, height, realPitch, snappedPitch, step, true, mc, drawContext);
    }

    public static void renderPitchLockIndicator(class_310 mc, class_332 drawContext) {
        if (mc.field_1724 == null) {
            return;
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 12;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = mc.field_1724.method_36455();
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(x, y, width, height, currentPitch, centerPitch, indicatorRange, false, mc, drawContext);
    }

    private static void renderPitchIndicator(int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange, class_310 mc, class_332 drawContext) {
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((class_3532.method_15338((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 textRenderer = mc.field_1772;
        if (isSnapRange) {
            String strUp = String.format("%6.1f\u00b0 ^", class_3532.method_15338((double)angleUp));
            String strDown = String.format("%6.1f\u00b0 v", class_3532.method_15338((double)angleDown));
            drawContext.method_51433(textRenderer, strUp, x + width + 4, y - 4, -1, false);
            drawContext.method_51433(textRenderer, strDown, x + width + 4, y + height - 4, -1, false);
            String str = String.format("%6.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.method_51433(textRenderer, str, x + width + 4, y + height / 2 - 4, -1, false);
        } else {
            String str = String.format("%4.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            drawContext.method_51433(textRenderer, str, x + width + 4, lineY - 4, -1, false);
        }
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        int yCenter = y + height / 2 - 1;
        if (isSnapRange && Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue();
            int snapThreshOffset = (int)((double)height * threshold / indicatorRange);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)(snapThreshOffset * 2), (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)2, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter + snapThreshOffset), (int)width, (int)2, (int)-14614752);
            }
        } else if (!isSnapRange) {
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(x + 1), (int)(yCenter - 1), (int)(width - 2), (int)2, (int)-4144960);
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(lineY - 1), (int)width, (int)2, (int)-1);
    }

    public static void renderBlockOutline(class_2338 pos, float expand, float lineWidth, Color4f color, class_310 mc) {
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(pos, color, expand, buffer, mc);
        try {
            class_9801 meshData = buffer.method_60800();
            class_286.method_43433((class_9801)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, Color4f color, double expand, class_287 buffer, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float minX = (float)((double)pos.method_10263() - dx - expand);
        float minY = (float)((double)pos.method_10264() - dy - expand);
        float minZ = (float)((double)pos.method_10260() - dz - expand);
        float maxX = (float)((double)pos.method_10263() - dx + expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - dy + expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - dz + expand + 1.0);
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (Color4f)color, (class_287)buffer);
    }

    public static void drawConnectingLineBatchedLines(class_2338 pos1, class_2338 pos2, boolean center, Color4f color, class_287 buffer, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float x1 = (float)((double)pos1.method_10263() - dx);
        float y1 = (float)((double)pos1.method_10264() - dy);
        float z1 = (float)((double)pos1.method_10260() - dz);
        float x2 = (float)((double)pos2.method_10263() - dx);
        float y2 = (float)((double)pos2.method_10264() - dy);
        float z2 = (float)((double)pos2.method_10260() - dz);
        if (center) {
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
            x2 += 0.5f;
            y2 += 0.5f;
            z2 += 0.5f;
        }
        buffer.method_22912(x1, y1, z1).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(x2, y2, z2).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderBlockOutlineOverlapping(class_2338 pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, Matrix4f matrix4f, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float minX = (float)((double)pos.method_10263() - dx - (double)expand);
        float minY = (float)((double)pos.method_10264() - dy - (double)expand);
        float minZ = (float)((double)pos.method_10260() - dz - (double)expand);
        float maxX = (float)((double)pos.method_10263() - dx + (double)expand + 1.0);
        float maxY = (float)((double)pos.method_10264() - dy + (double)expand + 1.0);
        float maxZ = (float)((double)pos.method_10260() - dz + (double)expand + 1.0);
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, minZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color1.r, color1.g, color1.b, color1.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color2.r, color2.g, color2.b, color2.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color3.r, color3.g, color3.b, color3.a);
        try {
            class_9801 meshData = buffer.method_60800();
            class_286.method_43433((class_9801)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void renderAreaOutline(class_2338 pos1, class_2338 pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, class_310 mc) {
        RenderSystem.lineWidth((float)lineWidth);
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        double minX = (double)Math.min(pos1.method_10263(), pos2.method_10263()) - dx;
        double minY = (double)Math.min(pos1.method_10264(), pos2.method_10264()) - dy;
        double minZ = (double)Math.min(pos1.method_10260(), pos2.method_10260()) - dz;
        double maxX = (double)Math.max(pos1.method_10263(), pos2.method_10263()) - dx + 1.0;
        double maxY = (double)Math.max(pos1.method_10264(), pos2.method_10264()) - dy + 1.0;
        double maxZ = (double)Math.max(pos1.method_10260(), pos2.method_10260()) - dz + 1.0;
        RenderUtils.drawBoundingBoxEdges((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        RenderUtils.drawBoundingBoxLinesX(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(buffer, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        try {
            class_9801 meshData = buffer.method_60800();
            class_286.method_43433((class_9801)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void drawBoundingBoxLinesX(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesY(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    private static void drawBoundingBoxLinesZ(class_287 buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Color4f color) {
        buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
        buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
    }

    public static void renderAreaSides(class_2338 pos1, class_2338 pos2, Color4f color, Matrix4f matrix4f, class_310 mc) {
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1576);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, buffer, mc);
        try {
            class_9801 meshData = buffer.method_60800();
            class_286.method_43433((class_9801)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }

    public static void renderAreaSidesBatched(class_2338 pos1, class_2338 pos2, Color4f color, double expand, class_287 buffer, class_310 mc) {
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        double minX = (double)Math.min(pos1.method_10263(), pos2.method_10263()) - dx - expand;
        double minY = (double)Math.min(pos1.method_10264(), pos2.method_10264()) - dy - expand;
        double minZ = (double)Math.min(pos1.method_10260(), pos2.method_10260()) - dz - expand;
        double maxX = (double)(Math.max(pos1.method_10263(), pos2.method_10263()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.method_10264(), pos2.method_10264()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.method_10260(), pos2.method_10260()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (class_287)buffer);
    }

    public static void renderAreaOutlineNoCorners(class_2338 pos1, class_2338 pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, class_310 mc) {
        int end;
        int xMin = Math.min(pos1.method_10263(), pos2.method_10263());
        int yMin = Math.min(pos1.method_10264(), pos2.method_10264());
        int zMin = Math.min(pos1.method_10260(), pos2.method_10260());
        int xMax = Math.max(pos1.method_10263(), pos2.method_10263());
        int yMax = Math.max(pos1.method_10264(), pos2.method_10264());
        int zMax = Math.max(pos1.method_10260(), pos2.method_10260());
        double expand = 0.001;
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double dx = cameraPos.field_1352;
        double dy = cameraPos.field_1351;
        double dz = cameraPos.field_1350;
        float dxMin = (float)(-dx - 0.001);
        float dyMin = (float)(-dy - 0.001);
        float dzMin = (float)(-dz - 0.001);
        float dxMax = (float)(-dx + 0.001);
        float dyMax = (float)(-dy + 0.001);
        float dzMax = (float)(-dz + 0.001);
        float minX = (float)xMin + dxMin;
        float minY = (float)yMin + dyMin;
        float minZ = (float)zMin + dzMin;
        float maxX = (float)xMax + dxMax;
        float maxY = (float)yMax + dyMax;
        float maxZ = (float)zMax + dzMax;
        RenderSystem.lineWidth((float)lineWidth);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
        int start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, minY, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, minY, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, maxY + 1.0f, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, maxY + 1.0f, minZ).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, minY, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, minY, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.method_22912((float)start + dxMin, maxY + 1.0f, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
            buffer.method_22912((float)end + dxMax, maxY + 1.0f, maxZ + 1.0f).method_22915(colorX.r, colorX.g, colorX.b, colorX.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(minX, (float)start + dyMin, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(minX, (float)end + dyMax, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, (float)start + dyMin, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(maxX + 1.0f, (float)end + dyMax, minZ).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(minX, (float)start + dyMin, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(minX, (float)end + dyMax, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, (float)start + dyMin, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
            buffer.method_22912(maxX + 1.0f, (float)end + dyMax, maxZ + 1.0f).method_22915(colorY.r, colorY.g, colorY.b, colorY.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(minX, minY, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(minX, minY, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMin && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMin && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, minY, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(maxX + 1.0f, minY, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.method_10263() == xMin && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMin && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(minX, maxY + 1.0f, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(minX, maxY + 1.0f, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        start = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMin || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.method_10263() == xMax && pos1.method_10264() == yMax && pos1.method_10260() == zMax || pos2.method_10263() == xMax && pos2.method_10264() == yMax && pos2.method_10260() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.method_22912(maxX + 1.0f, maxY + 1.0f, (float)start + dzMin).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
            buffer.method_22912(maxX + 1.0f, maxY + 1.0f, (float)end + dzMax).method_22915(colorZ.r, colorZ.g, colorZ.b, colorZ.a);
        }
        try {
            class_9801 meshData = buffer.method_60800();
            class_286.method_43433((class_9801)meshData);
            meshData.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

