/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.network;

import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.network.ServuxDebugHandler;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class ServuxDebugPacket
implements IClientPayloadData {
    private Type packetType;
    private class_2487 nbt;
    private class_2540 buffer;
    public static final int PROTOCOL_VERSION = 1;

    private ServuxDebugPacket(Type type) {
        this.packetType = type;
        this.nbt = new class_2487();
        this.clearPacket();
    }

    public static ServuxDebugPacket MetadataRequest(@Nullable class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_METADATA_REQUEST);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket MetadataResponse(@Nullable class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_METADATA);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket MetadataConfirm(@Nullable class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_METADATA_CONFIRM);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket DebugServiceRegister(@Nullable class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_DEBUG_SERVICE_REGISTER);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket DebugServiceUnregister(@Nullable class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_C2S_DEBUG_SERVICE_UNREGISTER);
        if (nbt != null) {
            packet.nbt.method_10543(nbt);
        }
        return packet;
    }

    public static ServuxDebugPacket ResponseS2CStart(@Nonnull class_2487 nbt) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_NBT_RESPONSE_START);
        packet.nbt.method_10543(nbt);
        return packet;
    }

    public static ServuxDebugPacket ResponseS2CData(@Nonnull class_2540 buffer) {
        ServuxDebugPacket packet = new ServuxDebugPacket(Type.PACKET_S2C_NBT_RESPONSE_DATA);
        packet.buffer = new class_2540(buffer.copy());
        packet.nbt = new class_2487();
        return packet;
    }

    private void clearPacket() {
        if (this.buffer != null) {
            this.buffer.method_52931();
            this.buffer = new class_2540(Unpooled.buffer());
        }
    }

    public int getVersion() {
        return 1;
    }

    public int getPacketType() {
        return this.packetType.get();
    }

    public int getTotalSize() {
        int total = 2;
        if (this.nbt != null && !this.nbt.method_33133()) {
            total += this.nbt.method_47988();
        }
        if (this.buffer != null) {
            total += this.buffer.readableBytes();
        }
        return total;
    }

    public Type getType() {
        return this.packetType;
    }

    public class_2487 getCompound() {
        return this.nbt;
    }

    public class_2540 getBuffer() {
        return this.buffer;
    }

    public boolean hasBuffer() {
        return this.buffer != null && this.buffer.isReadable();
    }

    public boolean hasNbt() {
        return this.nbt != null && !this.nbt.method_33133();
    }

    public boolean isEmpty() {
        return !this.hasBuffer() && !this.hasNbt();
    }

    public void toPacket(class_2540 output) {
        output.method_10804(this.packetType.get());
        switch (this.packetType.ordinal()) {
            case 6: {
                try {
                    output.method_52975(this.buffer.copy());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#toPacket: error writing buffer data to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                try {
                    output.method_10794((class_2520)this.nbt);
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#toPacket: error writing NBT to packet: [{}]", (Object)e.getLocalizedMessage());
                }
                break;
            }
            default: {
                MiniHUD.LOGGER.error("ServuxDebugPacket#toPacket: Unknown packet type!");
            }
        }
    }

    @Nullable
    public static ServuxDebugPacket fromPacket(class_2540 input) {
        int i = input.method_10816();
        Type type = ServuxDebugPacket.getType(i);
        if (type == null) {
            MiniHUD.LOGGER.warn("ServuxDebugPacket#fromPacket: invalid packet type received");
            return null;
        }
        switch (type.ordinal()) {
            case 6: {
                try {
                    return ServuxDebugPacket.ResponseS2CData(new class_2540(input.readBytes(input.readableBytes())));
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading S2C Bulk Response Buffer from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 1: {
                try {
                    return ServuxDebugPacket.MetadataRequest(input.method_10798());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 0: {
                try {
                    return ServuxDebugPacket.MetadataResponse(input.method_10798());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 2: {
                try {
                    return ServuxDebugPacket.MetadataConfirm(input.method_10798());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Metadata Confirm from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 3: {
                try {
                    return ServuxDebugPacket.DebugServiceRegister(input.method_10798());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Spawn Data Request from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            case 4: {
                try {
                    return ServuxDebugPacket.DebugServiceUnregister(input.method_10798());
                }
                catch (Exception e) {
                    MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: error reading Spawn Data Response from packet: [{}]", (Object)e.getLocalizedMessage());
                    break;
                }
            }
            default: {
                MiniHUD.LOGGER.error("ServuxDebugPacket#fromPacket: Unknown packet type!");
            }
        }
        return null;
    }

    public void clear() {
        if (this.nbt != null && !this.nbt.method_33133()) {
            this.nbt = new class_2487();
        }
        this.clearPacket();
        this.packetType = null;
    }

    @Nullable
    public static Type getType(int input) {
        for (Type type : Type.values()) {
            if (type.get() != input) continue;
            return type;
        }
        return null;
    }

    public static enum Type {
        PACKET_S2C_METADATA(1),
        PACKET_C2S_METADATA_REQUEST(2),
        PACKET_C2S_METADATA_CONFIRM(3),
        PACKET_C2S_DEBUG_SERVICE_REGISTER(4),
        PACKET_C2S_DEBUG_SERVICE_UNREGISTER(5),
        PACKET_S2C_NBT_RESPONSE_START(10),
        PACKET_S2C_NBT_RESPONSE_DATA(11);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        int get() {
            return this.type;
        }
    }

    public record Payload(ServuxDebugPacket data) implements class_8710
    {
        public static final class_8710.class_9154<Payload> ID = new class_8710.class_9154(ServuxDebugHandler.CHANNEL_ID);
        public static final class_9139<class_2540, Payload> CODEC = class_8710.method_56484(Payload::write, Payload::new);

        public Payload(class_2540 input) {
            this(ServuxDebugPacket.fromPacket(input));
        }

        private void write(class_2540 output) {
            this.data.toPacket(output);
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }
    }
}

