/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.data;

import com.google.common.collect.Lists;
import fi.dy.masa.malilib.network.ClientPlayHandler;
import fi.dy.masa.malilib.network.IPluginClientPlayHandler;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.Reference;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.debug.IMixinMobEntity;
import fi.dy.masa.minihud.network.ServuxDebugHandler;
import fi.dy.masa.minihud.network.ServuxDebugPacket;
import fi.dy.masa.minihud.util.DataStorage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1275;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1355;
import net.minecraft.class_1646;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3765;
import net.minecraft.class_4076;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4102;
import net.minecraft.class_4139;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4466;
import net.minecraft.class_4617;
import net.minecraft.class_4831;
import net.minecraft.class_5281;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_6880;
import net.minecraft.class_7045;
import net.minecraft.class_7260;
import net.minecraft.class_7893;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8707;
import net.minecraft.class_8708;
import net.minecraft.class_8710;
import net.minecraft.class_8712;
import net.minecraft.class_8713;
import net.minecraft.class_8716;
import net.minecraft.class_8721;
import net.minecraft.class_8722;
import net.minecraft.class_8723;
import net.minecraft.class_8724;
import net.minecraft.class_8725;
import net.minecraft.class_8726;
import net.minecraft.class_8728;
import net.minecraft.class_8729;
import net.minecraft.class_8949;
import net.minecraft.class_9004;
import org.jetbrains.annotations.Nullable;

public class DebugDataManager {
    private static final DebugDataManager INSTANCE = new DebugDataManager();
    private static final ServuxDebugHandler<ServuxDebugPacket.Payload> HANDLER = ServuxDebugHandler.getInstance();
    private boolean servuxServer = false;
    private boolean hasInValidServux = false;
    private String servuxVersion = "";
    private boolean shouldRegisterDebugService;

    public static DebugDataManager getInstance() {
        return INSTANCE;
    }

    public void onGameInit() {
        ClientPlayHandler.getInstance().registerClientPlayHandler(HANDLER);
        HANDLER.registerPlayPayload(ServuxDebugPacket.Payload.ID, ServuxDebugPacket.Payload.CODEC, 6);
    }

    public class_2960 getNetworkChannel() {
        return ServuxDebugHandler.CHANNEL_ID;
    }

    public IPluginClientPlayHandler<ServuxDebugPacket.Payload> getNetworkHandler() {
        return HANDLER;
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            MiniHUD.debugLog("DebugDataManager#reset() - log-out", new Object[0]);
            HANDLER.reset(this.getNetworkChannel());
            HANDLER.resetFailures(this.getNetworkChannel());
            this.servuxServer = false;
            this.hasInValidServux = false;
            this.servuxVersion = "";
        }
    }

    public void onWorldPre() {
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            HANDLER.registerPlayReceiver(ServuxDebugPacket.Payload.ID, HANDLER::receivePlayPayload);
        }
    }

    public void onWorldJoin() {
        MiniHUD.debugLog("DebugDataManager#onWorldJoin()", new Object[0]);
        if (!DataStorage.getInstance().hasIntegratedServer()) {
            if (RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue()) {
                this.registerDebugService();
            } else {
                this.unregisterDebugService();
            }
        }
    }

    public void setIsServuxServer() {
        this.servuxServer = true;
        if (this.hasInValidServux) {
            this.hasInValidServux = false;
        }
    }

    public void setServuxVersion(String ver) {
        this.servuxVersion = ver != null && !ver.isEmpty() ? ver : "unknown";
    }

    public String getServuxVersion() {
        if (this.hasServuxServer()) {
            return this.servuxVersion;
        }
        return "not_connected";
    }

    public boolean hasServuxServer() {
        return this.servuxServer;
    }

    public void registerDebugService() {
        this.shouldRegisterDebugService = true;
        if (!(this.hasServuxServer() || DataStorage.getInstance().hasIntegratedServer() || this.hasInValidServux)) {
            if (HANDLER.isPlayRegistered(this.getNetworkChannel())) {
                MiniHUD.debugLog("DebugDataManager#registerDebugService(): sending DEBUG_SERVICE_REGISTER to Servux", new Object[0]);
                class_2487 nbt = new class_2487();
                nbt.method_10582("version", Reference.MOD_STRING);
                HANDLER.encodeClientData(ServuxDebugPacket.DebugServiceRegister(nbt));
            }
        } else {
            this.shouldRegisterDebugService = false;
        }
    }

    public void requestMetadata() {
        if (this.shouldRegisterDebugService && !this.hasServuxServer() && !DataStorage.getInstance().hasIntegratedServer() && !this.hasInValidServux && HANDLER.isPlayRegistered(this.getNetworkChannel())) {
            MiniHUD.debugLog("DebugDataManager#requestMetadata(): sending REQUEST_METADATA to Servux", new Object[0]);
            class_2487 nbt = new class_2487();
            nbt.method_10582("version", Reference.MOD_STRING);
            HANDLER.encodeClientData(ServuxDebugPacket.MetadataRequest(nbt));
        }
    }

    public boolean receiveMetadata(class_2487 data) {
        if (!this.hasServuxServer() && !DataStorage.getInstance().hasIntegratedServer() && this.shouldRegisterDebugService) {
            MiniHUD.debugLog("DebugDataManager#receiveMetadata(): received METADATA from Servux", new Object[0]);
            if (data.method_10550("version") != 1) {
                MiniHUD.LOGGER.warn("debugDataChannel: Mis-matched protocol version!");
            }
            this.setServuxVersion(data.method_10558("servux"));
            this.setIsServuxServer();
            if (RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue()) {
                this.shouldRegisterDebugService = true;
                class_2487 nbt = new class_2487();
                nbt.method_10582("version", Reference.MOD_STRING);
                HANDLER.encodeClientData(ServuxDebugPacket.MetadataConfirm(nbt));
                return true;
            }
            this.unregisterDebugService();
        }
        return false;
    }

    public void unregisterDebugService() {
        if (this.hasServuxServer() || !RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue()) {
            this.servuxServer = false;
            if (!this.hasInValidServux) {
                MiniHUD.debugLog("DebugDataManager#unregisterDebugService(): for {}", this.servuxVersion != null ? this.servuxVersion : "<unknown>");
                HANDLER.encodeClientData(ServuxDebugPacket.DebugServiceUnregister(new class_2487()));
                HANDLER.reset(HANDLER.getPayloadChannel());
            }
        }
        this.shouldRegisterDebugService = false;
    }

    public void onPacketFailure() {
        this.shouldRegisterDebugService = false;
        this.servuxServer = false;
        this.hasInValidServux = true;
    }

    public boolean isEnabled() {
        return RendererToggle.DEBUG_DATA_MAIN_TOGGLE.getBooleanValue() && DataStorage.getInstance().hasIntegratedServer();
    }

    private void sendDebugData(class_3218 world, class_8710 payload) {
        if (this.isEnabled()) {
            class_2658 packet = new class_2658(payload);
            for (class_3222 player : world.method_18456()) {
                if (!player.field_13987.method_52413((class_2596)packet)) continue;
                player.field_13987.method_14364((class_2596)packet);
            }
        }
    }

    public void sendChunkWatchingChange(class_3218 world, class_1923 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_WORLDGEN.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_8729(pos.method_8323().method_10086(100), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f));
        }
    }

    public void sendPoiAdditions(class_3218 world, class_2338 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_VILLAGE_SECTIONS.getBooleanValue()) {
            world.method_19494().method_19132(pos).ifPresent(registryEntry -> {
                int tickets = world.method_19494().method_35155(pos);
                String name = registryEntry.method_55840();
                this.sendDebugData(world, (class_8710)new class_8722(pos, name, tickets));
            });
        }
    }

    public void sendPoiRemoval(class_3218 world, class_2338 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_VILLAGE_SECTIONS.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_8723(pos));
        }
    }

    public void sendPointOfInterest(class_3218 world, class_2338 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_VILLAGE_SECTIONS.getBooleanValue()) {
            int tickets = world.method_19494().method_35155(pos);
            this.sendDebugData(world, (class_8710)new class_8724(pos, tickets));
        }
    }

    public void sendPoi(class_3218 world, class_2338 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_VILLAGE_SECTIONS.getBooleanValue()) {
            class_6880 entry;
            class_2378 registry = world.method_30349().method_30530(class_7924.field_41246);
            class_4076 chunkSectionPos = class_4076.method_18682((class_2338)pos);
            Iterator iterator = registry.method_40286(class_7045.field_37045).iterator();
            do {
                if (!iterator.hasNext()) {
                    this.sendDebugData(world, (class_8710)new class_8728(Set.of(), Set.of(chunkSectionPos)));
                    return;
                }
                entry = (class_6880)iterator.next();
            } while (world.method_27056().method_38853(chunkSectionPos, (class_3195)entry.comp_349()).isEmpty());
            this.sendDebugData(world, (class_8710)new class_8728(Set.of(chunkSectionPos), Set.of()));
        }
    }

    public void sendPathfindingData(class_3218 world, class_1308 mob, @Nullable class_11 path, float nodeReachProximity) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_PATH_FINDING.getBooleanValue() && path != null) {
            this.sendDebugData(world, (class_8710)new class_8721(mob.method_5628(), path, nodeReachProximity));
        }
    }

    public void sendStructureStart(class_5281 world, class_3449 structureStart) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_STRUCTURES.getBooleanValue()) {
            ArrayList<class_8726.class_8727> pieces = new ArrayList<class_8726.class_8727>();
            for (int i = 0; i < structureStart.method_14963().size(); ++i) {
                pieces.add(new class_8726.class_8727(((class_3443)structureStart.method_14963().get(i)).method_14935(), i == 0));
            }
            class_3218 serverWorld = world.method_8410();
            this.sendDebugData(serverWorld, (class_8710)new class_8726(serverWorld.method_27983(), structureStart.method_14969(), pieces));
        }
    }

    public void sendGoalSelector(class_3218 world, class_1308 mob, class_1355 goalSelector) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_GOAL_SELECTOR.getBooleanValue()) {
            List<class_8716.class_8717> goals = ((IMixinMobEntity)mob).minihud_getGoalSelector().method_35115().stream().map(goal -> new class_8716.class_8717(goal.method_19057(), goal.method_19056(), goal.method_19058().toString())).toList();
            this.sendDebugData(world, (class_8710)new class_8716(mob.method_5628(), mob.method_24515(), goals));
        }
    }

    public void sendRaids(class_3218 world, Collection<class_3765> raids) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_RAID_CENTER.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_8725(raids.stream().map(class_3765::method_16495).toList()));
        }
    }

    public void sendBrainDebugData(class_3218 serverWorld, class_1309 livingEntity) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_BRAIN.getBooleanValue()) {
            boolean wantsGolem;
            String inventory;
            int xp;
            String profession;
            int angerLevel;
            class_1308 entity = (class_1308)livingEntity;
            if (entity instanceof class_7260) {
                class_7260 wardenEntity = (class_7260)entity;
                angerLevel = wardenEntity.method_42222();
            } else {
                angerLevel = -1;
            }
            ArrayList gossips = new ArrayList();
            HashSet<class_2338> pois = new HashSet<class_2338>();
            HashSet<class_2338> potentialPois = new HashSet<class_2338>();
            if (entity instanceof class_1646) {
                class_1646 villager = (class_1646)entity;
                profession = villager.method_7231().method_16924().toString();
                xp = villager.method_19269();
                inventory = villager.method_35199().toString();
                wantsGolem = villager.method_20687(serverWorld.method_8510());
                villager.method_21651().method_35120().forEach((uuid, associatedGossip) -> {
                    class_1297 gossipEntity = serverWorld.method_14190(uuid);
                    if (gossipEntity != null) {
                        String name = class_4617.method_36154((class_1297)gossipEntity);
                        ObjectIterator objectIterator = associatedGossip.object2IntEntrySet().iterator();
                        while (objectIterator.hasNext()) {
                            Object2IntMap.Entry typeEntry;
                            Object2IntMap.Entry entry = typeEntry = (Object2IntMap.Entry)objectIterator.next();
                            gossips.add(name + ": " + ((class_4139)entry.getKey()).method_15434() + " " + String.valueOf(entry.getValue()));
                        }
                    }
                });
                class_4095 brain = villager.method_18868();
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18438, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18439, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_18440, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_19008, pois);
                this.addPoi(brain, (class_4140<class_4208>)class_4140.field_25160, potentialPois);
            } else {
                profession = "";
                xp = 0;
                inventory = "";
                wantsGolem = false;
            }
            this.sendDebugData(serverWorld, (class_8710)new class_8708(new class_8708.class_4232(entity.method_5667(), entity.method_5628(), entity.method_5477().getString(), profession, xp, entity.method_6032(), entity.method_6063(), entity.method_19538(), inventory, entity.method_5942().method_6345(), wantsGolem, angerLevel, entity.method_18868().method_35059().stream().map(class_4168::toString).toList(), entity.method_18868().method_27074().stream().map(class_7893::method_46910).toList(), this.listMemories((class_1309)entity, serverWorld.method_8510()), gossips, pois, potentialPois)));
        }
    }

    public void sendBeeDebugData(class_3218 world, class_4466 bee) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_BEEDATA.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_8707(new class_8707.class_5243(bee.method_5667(), bee.method_5628(), bee.method_19538(), bee.method_5942().method_6345(), bee.method_23884(), bee.method_21778(), bee.method_35161(), bee.method_35163().method_35115().stream().map(prioritizedGoal -> prioritizedGoal.method_19058().toString()).collect(Collectors.toSet()), bee.method_35162())));
        }
    }

    public void sendBreezeDebugData(class_3218 world, class_8949 breeze) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_BREEZE_JUMP.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_9004(new class_9004.class_9005(breeze.method_5667(), breeze.method_5628(), breeze.method_5968() == null ? null : Integer.valueOf(breeze.method_5968().method_5628()), (class_2338)breeze.method_18868().method_18904(class_4140.field_47258).orElse(null))));
        }
    }

    public void sendGameEvent(class_3218 world, class_6880<class_5712> event, class_243 pos) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_GAME_EVENT.getBooleanValue()) {
            event.method_40230().ifPresent(key -> this.sendDebugData(world, (class_8710)new class_8712(key, pos)));
        }
    }

    public void sendGameEventListener(class_3218 world, class_5714 eventListener) {
        if (!this.isEnabled()) {
            return;
        }
        if (RendererToggle.DEBUG_GAME_EVENT.getBooleanValue()) {
            this.sendDebugData(world, (class_8710)new class_8713(eventListener.method_32946(), eventListener.method_32948()));
        }
    }

    private void addPoi(class_4095<?> brain, class_4140<class_4208> memoryModuleType, Set<class_2338> set) {
        Optional<class_2338> opt = brain.method_18904(memoryModuleType).map(class_4208::comp_2208);
        Objects.requireNonNull(set);
        opt.ifPresent(set::add);
    }

    public List<String> listMemories(class_1309 entity, long currentTime) {
        Map map = entity.method_18868().method_35058();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry memoryModuleTypeOptionalEntry : map.entrySet()) {
            Object string;
            class_4140 memoryModuleType = (class_4140)memoryModuleTypeOptionalEntry.getKey();
            Optional optional = (Optional)memoryModuleTypeOptionalEntry.getValue();
            if (optional.isPresent()) {
                class_4831 memory = (class_4831)optional.get();
                Object object = memory.method_24637();
                if (memoryModuleType == class_4140.field_19009) {
                    long l = currentTime - (Long)object;
                    string = l + " ticks ago";
                } else if (memory.method_24914()) {
                    String var10000 = this.format((class_3218)entity.method_37908(), object);
                    string = var10000 + " (ttl: " + memory.method_35127() + ")";
                } else {
                    string = this.format((class_3218)entity.method_37908(), object);
                }
            } else {
                string = "-";
            }
            String type = class_7923.field_41129.method_10221((Object)memoryModuleType).method_12832();
            list.add(type + ": " + (String)string);
        }
        list.sort(String::compareTo);
        return list;
    }

    private String format(class_3218 world, @Nullable Object object) {
        if (object == null) {
            return "-";
        }
        if (object instanceof UUID) {
            return this.format(world, world.method_14190((UUID)object));
        }
        if (object instanceof class_1309) {
            class_1297 entity = (class_1297)object;
            return class_4617.method_36154((class_1297)entity);
        }
        if (object instanceof class_1275) {
            return ((class_1275)object).method_5477().getString();
        }
        if (object instanceof class_4142) {
            return this.format(world, ((class_4142)object).method_19094());
        }
        if (object instanceof class_4102) {
            return this.format(world, ((class_4102)object).method_35066());
        }
        if (object instanceof class_4208) {
            return this.format(world, ((class_4208)object).comp_2208());
        }
        if (object instanceof class_4099) {
            return this.format(world, ((class_4099)object).method_18989());
        }
        if (object instanceof class_1282) {
            class_1297 entity = ((class_1282)object).method_5529();
            return entity == null ? object.toString() : this.format(world, entity);
        }
        if (!(object instanceof Collection)) {
            return object.toString();
        }
        ArrayList list = Lists.newArrayList();
        for (Object object2 : (Iterable)object) {
            list.add(this.format(world, object2));
        }
        return ((Object)list).toString();
    }
}

