/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.mixin.IMixinIngredient;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10294;
import net.minecraft.class_10295;
import net.minecraft.class_10300;
import net.minecraft.class_10301;
import net.minecraft.class_10314;
import net.minecraft.class_10315;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class RecipeUtils {
    public static String getRecipeCategoryId(class_10355 category) {
        class_5321 key = class_7923.field_54927.method_29113((Object)category).orElse(null);
        if (key != null) {
            return key.method_29177().toString();
        }
        return "";
    }

    @Nullable
    public static class_10355 getRecipeCategoryFromId(String id) {
        class_6880.class_6883 catReference = class_7923.field_54927.method_10223(class_2960.method_12829((String)id)).orElse(null);
        if (catReference != null && catReference.method_40227()) {
            return (class_10355)catReference.comp_349();
        }
        return null;
    }

    public static boolean compareStacksAndIngredients(List<class_1799> left, List<class_1856> right, int count, Type type) {
        if (left.isEmpty() || right.isEmpty()) {
            return false;
        }
        if (type == Type.SHAPELESS) {
            return RecipeUtils.compareShapelessRecipe(left, right);
        }
        if (type == Type.SHAPED) {
            return RecipeUtils.compareShapedRecipe(left, right);
        }
        return false;
    }

    public static boolean compareShapedRecipe(List<class_1799> left, List<class_1856> right) {
        int lPos = 0;
        for (int i = 0; i < right.size(); ++i) {
            class_1799 lStack = left.get(lPos);
            while (lStack.method_7960() && ++lPos < 9) {
                lStack = left.get(lPos);
            }
            if (!RecipeUtils.checkMatchingItemsEach(lStack, lPos, i, right.get(i))) {
                return false;
            }
            ++lPos;
        }
        return true;
    }

    public static boolean compareShapelessRecipe(List<class_1799> left, List<class_1856> right) {
        for (int i = 0; i < left.size(); ++i) {
            class_1799 lStack = left.get(i);
            boolean pass = false;
            if (lStack.method_7960()) continue;
            for (int rPos = 0; rPos < right.size(); ++rPos) {
                if (!RecipeUtils.checkMatchingItemsEach(lStack, i, rPos, right.get(rPos))) continue;
                pass = true;
            }
            if (pass) continue;
            return false;
        }
        return true;
    }

    private static boolean checkMatchingItemsEach(class_1799 lStack, int lPos, int i, class_1856 ri) {
        List rItems = ((IMixinIngredient)ri).itemscroller_getEntries().method_40239().toList();
        for (class_6880 rItem : rItems) {
            if (ri.method_8093(lStack)) {
                return true;
            }
            if (!RecipeUtils.areStacksEqual(lStack, new class_1799(rItem))) continue;
            return true;
        }
        return false;
    }

    public static boolean areStacksEqual(class_1799 left, class_1799 right) {
        return class_1799.method_7984((class_1799)left, (class_1799)right) && left.method_7947() == right.method_7947();
    }

    private static void dumpStacks(List<class_1799> stacks, String side) {
        int i = 0;
        System.out.printf("DUMP [%s] -->\n", side);
        for (class_1799 stack : stacks) {
            System.out.printf(" %s[%d] // [%s]\n", side, i, stack.toString());
            ++i;
        }
        System.out.printf("DUMP END [%s]\n", side);
    }

    private static void dumpIngs(List<class_1856> ings, String side) {
        int i = 0;
        System.out.printf("DUMP [%s] -->\n", side);
        for (class_1856 ing : ings) {
            List items = ((IMixinIngredient)ing).itemscroller_getEntries().method_40239().toList();
            System.out.printf(" %s[%d] //", side, i);
            for (class_6880 item : items) {
                System.out.printf(" [%s]", item.method_55840());
            }
            System.out.print("// []\n");
            ++i;
        }
        System.out.printf("DUMP END [%s]\n", side);
    }

    public static enum Type {
        FURNACE,
        SHAPED,
        SHAPELESS,
        SMITHING,
        STONECUTTER,
        UNKNOWN;


        public static Type fromRecipeDisplay(class_10295 type) {
            class_10295 class_102952 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_10294.class, class_10301.class, class_10300.class, class_10314.class, class_10315.class}, (Object)class_102952, n)) {
                case 0 -> {
                    class_10294 ignored = (class_10294)class_102952;
                    yield FURNACE;
                }
                case 1 -> {
                    class_10301 ignored = (class_10301)class_102952;
                    yield SHAPELESS;
                }
                case 2 -> {
                    class_10300 ignored = (class_10300)class_102952;
                    yield SHAPED;
                }
                case 3 -> {
                    class_10314 ignored = (class_10314)class_102952;
                    yield SMITHING;
                }
                case 4 -> {
                    class_10315 ignored = (class_10315)class_102952;
                    yield STONECUTTER;
                }
                default -> UNKNOWN;
            };
        }
    }
}

