/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.nbt.NbtUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_1735;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_465;
import net.minecraft.class_5455;

public class RecipeStorage {
    private static final int MAX_PAGES = 8;
    private static final int MAX_RECIPES = 18;
    private static final RecipeStorage INSTANCE = new RecipeStorage(144);
    private final RecipePattern[] recipes;
    private int selected;
    private boolean dirty;

    public static RecipeStorage getInstance() {
        return INSTANCE;
    }

    public RecipeStorage(int recipeCount) {
        this.recipes = new RecipePattern[recipeCount];
        this.initRecipes();
    }

    public void reset(boolean isLogout) {
        if (isLogout) {
            this.clearRecipes();
        }
    }

    private void initRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new RecipePattern();
        }
    }

    private void clearRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.clearRecipe(i);
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void changeSelectedRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            this.selected = index;
            this.dirty = true;
        }
    }

    public void scrollSelection(boolean forward) {
        this.changeSelectedRecipe(this.selected + (forward ? 1 : -1));
    }

    public int getFirstVisibleRecipeId() {
        return this.getCurrentRecipePage() * this.getRecipeCountPerPage();
    }

    public int getTotalRecipeCount() {
        return this.recipes.length;
    }

    public int getRecipeCountPerPage() {
        return 18;
    }

    public int getCurrentRecipePage() {
        return this.getSelection() / this.getRecipeCountPerPage();
    }

    @Nonnull
    public RecipePattern getRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            return this.recipes[index];
        }
        return this.recipes[0];
    }

    @Nonnull
    public RecipePattern getSelectedRecipe() {
        return this.getRecipe(this.getSelection());
    }

    public void storeCraftingRecipeToCurrentSelection(class_1735 slot, class_465<?> gui, boolean clearIfEmpty, boolean fromKeybind, class_310 mc) {
        this.storeCraftingRecipe(this.getSelection(), slot, gui, clearIfEmpty, fromKeybind, mc);
    }

    public void storeCraftingRecipe(int index, class_1735 slot, class_465<?> gui, boolean clearIfEmpty, boolean fromKeybind, class_310 mc) {
        this.getRecipe(index).storeCraftingRecipe(slot, gui, clearIfEmpty, fromKeybind, mc);
        this.dirty = true;
    }

    public void clearRecipe(int index) {
        this.getRecipe(index).clearRecipe();
        this.dirty = true;
    }

    public void onAddToRecipeBook(class_10297 entry) {
        class_310 mc = class_310.method_1551();
        for (RecipePattern recipe : this.recipes) {
            if (recipe.isEmpty() || !recipe.matchClientRecipeBookEntry(entry, mc)) continue;
            ItemScroller.debugLog("onAddToRecipeBook(): Positive Match for result stack: [{}] networkId [{}]", recipe.getResult().toString(), entry.comp_3262().comp_3267());
            recipe.storeNetworkRecipeId(entry.comp_3262());
            recipe.storeRecipeCategory(entry.comp_3265());
            recipe.storeRecipeDisplayEntry(entry);
            break;
        }
    }

    private void readFromNBT(class_2487 nbt, @Nonnull class_5455 registryManager) {
        if (nbt == null || !nbt.method_10573("Recipes", 9)) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i].clearRecipe();
        }
        class_2499 tagList = nbt.method_10554("Recipes", 10);
        int count = tagList.size();
        for (int i = 0; i < count; ++i) {
            class_2487 tag = tagList.method_10602(i);
            byte index = tag.method_10571("RecipeIndex");
            if (index < 0 || index >= this.recipes.length) continue;
            this.recipes[index].readFromNBT(tag, registryManager);
            if (tag.method_10573("RecipeCategory", 8)) {
                this.recipes[index].storeRecipeCategory(RecipeUtils.getRecipeCategoryFromId(tag.method_10558("RecipeCategory")));
            }
            if (!tag.method_10545("LastNetworkId")) continue;
            this.recipes[index].storeNetworkRecipeId(new class_10298(tag.method_10550("LastNetworkId")));
        }
        this.changeSelectedRecipe(nbt.method_10571("Selected"));
    }

    private class_2487 writeToNBT(@Nonnull class_5455 registry) {
        class_2499 tagRecipes = new class_2499();
        class_2487 nbt = new class_2487();
        for (int i = 0; i < this.recipes.length; ++i) {
            String id;
            if (!this.recipes[i].isValid()) continue;
            RecipePattern entry = this.recipes[i];
            class_2487 tag = entry.writeToNBT(registry);
            tag.method_10567("RecipeIndex", (byte)i);
            if (entry.getRecipeCategory() != null && !(id = RecipeUtils.getRecipeCategoryId(entry.getRecipeCategory())).isEmpty()) {
                tag.method_10582("RecipeCategory", id);
            }
            if (entry.getNetworkRecipeId() != null) {
                tag.method_10569("LastNetworkId", entry.getNetworkRecipeId().comp_3267());
            }
            tagRecipes.add((Object)tag);
        }
        nbt.method_10566("Recipes", (class_2520)tagRecipes);
        nbt.method_10567("Selected", (byte)this.selected);
        return nbt;
    }

    private String getFileName() {
        if (!Configs.Generic.SCROLL_CRAFT_RECIPE_FILE_GLOBAL.getBooleanValue()) {
            String worldName = StringUtils.getWorldOrServerName();
            if (worldName != null) {
                return "recipes_" + worldName + ".nbt";
            }
            return "recipes_unknown.nbt";
        }
        return "recipes.nbt";
    }

    private Path getSaveDirAsPath() {
        return FileUtils.getMinecraftDirectoryAsPath().resolve("itemscroller");
    }

    public void readFromDisk(@Nonnull class_5455 registry) {
        try {
            Path saveDir = this.getSaveDirAsPath();
            if (Files.isDirectory(saveDir, new LinkOption[0])) {
                Path file = saveDir.resolve(this.getFileName());
                if (Files.exists(file, new LinkOption[0])) {
                    class_2487 nbtIn = NbtUtils.readNbtFromFileAsPath((Path)file, (class_2505)class_2505.method_53898());
                    if (nbtIn != null && !nbtIn.method_33133()) {
                        this.initRecipes();
                        this.readFromNBT(nbtIn, registry);
                    } else {
                        ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes from file '{}'", (Object)file.toAbsolutePath());
                    }
                }
            } else {
                ItemScroller.LOGGER.warn("readFromDisk(): Error reading recipes saveDir '{}'", (Object)saveDir.toAbsolutePath());
            }
        }
        catch (Exception e) {
            ItemScroller.LOGGER.warn("readFromDisk(): Failed to read recipes from file", (Throwable)e);
        }
    }

    public void writeToDisk(@Nonnull class_5455 registry) {
        if (this.dirty) {
            try {
                Path saveDir = this.getSaveDirAsPath();
                if (!Files.exists(saveDir, new LinkOption[0])) {
                    FileUtils.createDirectoriesIfMissing((Path)saveDir);
                }
                if (Files.isDirectory(saveDir, new LinkOption[0])) {
                    Path fileTmp = saveDir.resolve(this.getFileName() + ".tmp");
                    Path fileReal = saveDir.resolve(this.getFileName());
                    NbtUtils.writeCompressed((class_2487)this.writeToNBT(registry), (Path)fileTmp);
                    if (Files.exists(fileReal, new LinkOption[0])) {
                        Files.delete(fileReal);
                    }
                    Files.move(fileTmp, fileReal, new CopyOption[0]);
                    this.dirty = false;
                }
            }
            catch (Exception e) {
                ItemScroller.LOGGER.warn("writeToDisk(): Failed to write recipes to file!", (Throwable)e);
            }
        }
    }
}

