/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import com.llamalad7.mixinextras.lib.apache.commons.tuple.Pair;
import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.mixin.IMixinClientRecipeBook;
import fi.dy.masa.itemscroller.mixin.IMixinRecipeBookScreen;
import fi.dy.masa.itemscroller.mixin.IMixinRecipeBookWidget;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.RecipeUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10260;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_10363;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_465;
import net.minecraft.class_507;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;

public class RecipePattern {
    private class_1799 result = InventoryUtils.EMPTY_STACK;
    private class_1799[] recipe = new class_1799[9];
    private class_8786<?> vanillaRecipe;
    private class_10298 networkRecipeId;
    private class_10297 displayEntry;
    private class_10355 category;
    private long recipeSaveTime;

    public RecipePattern() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new class_1799[size];
        }
    }

    public void clearRecipe() {
        Arrays.fill(this.recipe, InventoryUtils.EMPTY_STACK);
        this.result = InventoryUtils.EMPTY_STACK;
        this.vanillaRecipe = null;
        this.networkRecipeId = null;
        this.displayEntry = null;
        this.category = null;
        this.recipeSaveTime = -1L;
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    @Nullable
    public <T extends class_9695> class_1860<T> lookupVanillaRecipe(class_1937 world) {
        class_3218 serverWorld;
        int recipeSize;
        this.vanillaRecipe = null;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return null;
        }
        if (this.recipe.length == 4) {
            recipeSize = 2;
        } else if (this.recipe.length == 9) {
            recipeSize = 3;
        } else {
            return null;
        }
        class_3218 class_32182 = serverWorld = mc.method_1576() != null ? mc.method_1576().method_3847(mc.field_1687.method_27983()) : null;
        if (mc.method_1496() && serverWorld != null) {
            class_9694 input = class_9694.method_59986((int)recipeSize, (int)recipeSize, Arrays.asList(this.recipe));
            Optional opt = serverWorld.method_64577().method_8132(class_3956.field_17545, (class_9695)input, (class_1937)serverWorld);
            if (opt.isPresent()) {
                class_8786 recipeEntry = (class_8786)opt.get();
                class_1860 match = ((class_8786)opt.get()).comp_1933();
                class_1799 result = match.method_8116((class_9695)input, (class_7225.class_7874)serverWorld.method_30349());
                if (result != null && !result.method_7960()) {
                    this.vanillaRecipe = recipeEntry;
                    this.storeIdFromClientRecipeBook(mc);
                    return match;
                }
            }
        } else {
            this.storeIdFromClientRecipeBook(mc);
        }
        return null;
    }

    public void storeIdFromClientRecipeBook(class_310 mc) {
        Pair<class_10298, class_10297> pair = this.matchClientRecipeBook(mc);
        if (pair == null || pair.getLeft() == null || pair.getRight() == null) {
            return;
        }
        this.storeNetworkRecipeId((class_10298)pair.getLeft());
        this.storeRecipeCategory(((class_10297)pair.getRight()).comp_3265());
        this.storeRecipeDisplayEntry((class_10297)pair.getRight());
    }

    public void storeNetworkRecipeId(class_10298 id) {
        this.networkRecipeId = id;
    }

    public void storeRecipeDisplayEntry(class_10297 entry) {
        this.displayEntry = entry;
    }

    public void storeRecipeCategory(class_10355 category) {
        this.category = category;
    }

    @Nullable
    public class_10298 getNetworkRecipeId() {
        return this.networkRecipeId;
    }

    @Nullable
    public class_10297 getRecipeDisplayEntry() {
        return this.displayEntry;
    }

    @Nullable
    public class_10355 getRecipeCategory() {
        return this.category;
    }

    public boolean matchRecipeCategory(class_10355 category) {
        return this.getRecipeCategory() != null && this.getRecipeCategory().equals(category);
    }

    @Nullable
    public Pair<class_10298, class_10297> matchClientRecipeBook(class_310 mc) {
        if (mc.field_1724 == null || mc.field_1687 == null || this.isEmpty()) {
            return null;
        }
        class_299 recipeBook = mc.field_1724.method_3130();
        class_10352 ctx = class_10363.method_65008((class_1937)mc.field_1687);
        Map<class_10298, class_10297> recipeMap = ((IMixinClientRecipeBook)recipeBook).itemscroller_getRecipeMap();
        if (recipeMap.size() < 1) {
            return null;
        }
        for (class_10298 id : recipeMap.keySet()) {
            class_10297 entry = recipeMap.get(id);
            if (entry == null || this.getRecipeCategory() != null && !this.matchRecipeCategory(entry.comp_3265())) continue;
            List stacks = entry.method_64730(ctx);
            if (!RecipeUtils.areStacksEqual(this.getResult(), (class_1799)stacks.getFirst())) continue;
            Pair pair = Pair.of((Object)id, (Object)entry);
            return pair;
        }
        return null;
    }

    public boolean matchClientRecipeBookEntry(class_10297 entry, class_310 mc) {
        if (mc.field_1687 == null || this.isEmpty()) {
            return false;
        }
        List<class_1799> recipeStacks = Arrays.stream(this.getRecipeItems()).toList();
        List stacks = entry.method_64730(class_10363.method_65008((class_1937)mc.field_1687));
        if (RecipeUtils.areStacksEqual(this.getResult(), (class_1799)stacks.getFirst())) {
            if (entry.comp_3266().isPresent()) {
                return RecipeUtils.compareStacksAndIngredients(recipeStacks, (List)entry.comp_3266().get(), this.countRecipeItems(), RecipeUtils.Type.fromRecipeDisplay(entry.comp_3263()));
            }
            return true;
        }
        return false;
    }

    public void storeCraftingRecipe(class_1735 slot, class_465<? extends class_1703> gui, boolean clearIfEmpty, boolean fromKeybind, class_310 mc) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null) {
            if (slot.method_7681()) {
                int gridSize = range.getSlotCount();
                if (fromKeybind) {
                    int numSlots = gui.method_17577().field_7761.size();
                    this.ensureRecipeSizeAndClearRecipe(gridSize);
                    int i = 0;
                    for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                        class_1735 slotTmp = gui.method_17577().method_7611(s);
                        this.recipe[i] = slotTmp.method_7681() ? slotTmp.method_7677().method_7972() : InventoryUtils.EMPTY_STACK;
                    }
                    this.recipeSaveTime = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - this.recipeSaveTime < 4000L) {
                    this.recipeSaveTime = System.currentTimeMillis();
                    gui.method_17577().method_34254(class_1799.field_8037);
                    InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
                    return;
                }
                this.result = slot.method_7677().method_7972();
                this.lookupVanillaRecipe((class_1937)mc.field_1687);
                this.storeSelectedRecipeIdFromGui(gui);
                InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
            } else if (clearIfEmpty) {
                this.clearRecipe();
            }
        }
    }

    public void storeSelectedRecipeIdFromGui(class_465<? extends class_1703> gui) {
        class_299 recipeBook;
        Map<class_10298, class_10297> recipeMap;
        class_10298 id;
        class_10260 rbs;
        class_507<?> widget;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (gui instanceof class_10260 && (widget = ((IMixinRecipeBookScreen)(rbs = (class_10260)gui)).itemscroller_getRecipeBookWidget()) != null && (id = ((IMixinRecipeBookWidget)widget).itemscroller_getSelectedRecipe()) != null && (recipeMap = ((IMixinClientRecipeBook)(recipeBook = mc.field_1724.method_3130())).itemscroller_getRecipeMap()).containsKey(id)) {
            class_10297 entry = recipeMap.get(id);
            class_1799 result = (class_1799)entry.method_64730(class_10363.method_65008((class_1937)mc.field_1687)).getFirst();
            if (RecipeUtils.areStacksEqual(this.getResult(), result)) {
                if (entry.comp_3266().isPresent()) {
                    if (RecipeUtils.compareStacksAndIngredients(Arrays.asList(this.getRecipeItems()), (List)entry.comp_3266().get(), this.countRecipeItems(), RecipeUtils.Type.fromRecipeDisplay(entry.comp_3263()))) {
                        ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): Matched Ingredients for result stack [{}] networkId [{}]", this.getResult().toString(), id.comp_3267());
                        this.storeNetworkRecipeId(id);
                        this.storeRecipeCategory(entry.comp_3265());
                        this.storeRecipeDisplayEntry(entry);
                    } else {
                        ItemScroller.LOGGER.warn("storeSelectedRecipeIdFromGui(): failed to match Ingredients for result stack [{}] networkId [{}]", (Object)this.getResult().toString(), (Object)id.comp_3267());
                    }
                } else {
                    ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): No craftingRequirements present, Saving Blindly for result stack [{}] networkId [{}]", this.getResult().toString(), id.comp_3267());
                    this.storeNetworkRecipeId(id);
                    this.storeRecipeCategory(entry.comp_3265());
                    this.storeRecipeDisplayEntry(entry);
                }
            } else {
                Pair<class_10298, class_10297> pair = this.matchClientRecipeBook(mc);
                if (pair != null) {
                    ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): matching pair for result stack [{}] networkId [{}]", this.getResult().toString(), ((class_10298)pair.getLeft()).comp_3267());
                    this.storeNetworkRecipeId((class_10298)pair.getLeft());
                    this.storeRecipeCategory(((class_10297)pair.getRight()).comp_3265());
                    this.storeRecipeDisplayEntry((class_10297)pair.getRight());
                } else {
                    this.result = result.method_7972();
                    pair = this.matchClientRecipeBook(mc);
                    if (pair != null) {
                        ItemScroller.debugLog("storeSelectedRecipeIdFromGui(): RE-matching pair results stack [{}] networkId [{}]", this.getResult().toString(), ((class_10298)pair.getLeft()).comp_3267());
                        this.storeNetworkRecipeId((class_10298)pair.getLeft());
                        this.storeRecipeCategory(((class_10297)pair.getRight()).comp_3265());
                        this.storeRecipeDisplayEntry((class_10297)pair.getRight());
                    } else {
                        ItemScroller.LOGGER.error("storeSelectedRecipeIdFromGui(): Final Exception matching results stack [{}] versus [{}] --> Clearing Recipe", (Object)this.getResult().toString(), (Object)result.toString());
                        this.clearRecipe();
                    }
                }
            }
        }
    }

    public void copyRecipeFrom(RecipePattern other) {
        int size = other.getRecipeLength();
        class_1799[] otherRecipe = other.getRecipeItems();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].method_7972() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().method_7972() : InventoryUtils.EMPTY_STACK;
        this.vanillaRecipe = other.vanillaRecipe;
        this.networkRecipeId = other.networkRecipeId;
        this.displayEntry = other.displayEntry;
        this.category = other.category;
        this.recipeSaveTime = System.currentTimeMillis();
    }

    public void readFromNBT(@Nonnull class_2487 nbt, @Nonnull class_5455 registryManager) {
        if (nbt.method_10573("Result", 10) && nbt.method_10573("Ingredients", 9)) {
            class_2499 tagIngredients = nbt.method_10554("Ingredients", 10);
            int count = tagIngredients.size();
            int length = nbt.method_10550("Length");
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                class_2487 tag = tagIngredients.method_10602(i);
                int slot = tag.method_10550("Slot");
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = class_1799.method_57359((class_7225.class_7874)registryManager, (class_2487)tag);
            }
            this.result = class_1799.method_57359((class_7225.class_7874)registryManager, (class_2487)nbt.method_10562("Result"));
        }
    }

    @Nonnull
    public class_2487 writeToNBT(@Nonnull class_5455 registryManager) {
        class_2487 nbt = new class_2487();
        if (this.isValid()) {
            class_2487 tag = (class_2487)this.result.method_57358((class_7225.class_7874)registryManager);
            nbt.method_10569("Length", this.recipe.length);
            nbt.method_10566("Result", (class_2520)tag);
            class_2499 tagIngredients = new class_2499();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (this.recipe[i].method_7960() || InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = new class_2487();
                tag.method_10543((class_2487)this.recipe[i].method_57358((class_7225.class_7874)registryManager));
                tag.method_10569("Slot", i);
                tagIngredients.add((Object)tag);
            }
            nbt.method_10566("Ingredients", (class_2520)tagIngredients);
        }
        return nbt;
    }

    public class_1799 getResult() {
        if (!this.result.method_7960()) {
            return this.result;
        }
        return InventoryUtils.EMPTY_STACK;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public class_1799[] getRecipeItems() {
        return this.recipe;
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.getRecipeLength(); ++i) {
            if (this.getRecipeItems()[i].method_7960()) continue;
            empty = false;
        }
        return empty || this.getResult().method_7960();
    }

    public int countRecipeItems() {
        int count = 0;
        for (class_1799 itemStack : this.recipe) {
            if (itemStack.method_7960()) continue;
            ++count;
        }
        return count;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }

    @Nullable
    public class_8786<?> getVanillaRecipeEntry() {
        return this.vanillaRecipe;
    }

    @Nullable
    public <T extends class_9695> class_1860<T> getVanillaRecipe() {
        if (this.recipe == null) {
            return null;
        }
        if (this.vanillaRecipe != null) {
            return this.vanillaRecipe.comp_1933();
        }
        return null;
    }
}

