/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.gui.GuiConfigs;
import fi.dy.masa.itemscroller.mixin.IMixinCraftingResultSlot;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.RecipePattern;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.ClickPacketBuffer;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBooleanConfigWithMessage;
import fi.dy.masa.malilib.interfaces.IClientTickHandler;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2547;
import net.minecraft.class_2653;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_8566;
import net.minecraft.class_9695;

public class KeybindCallbacks
implements IHotkeyCallback,
IClientTickHandler {
    private static final KeybindCallbacks INSTANCE = new KeybindCallbacks();
    protected int massCraftTicker;
    private boolean recipeBookClicks = false;

    public static KeybindCallbacks getInstance() {
        return INSTANCE;
    }

    private KeybindCallbacks() {
    }

    public void setCallbacks() {
        for (ConfigHotkey hotkey : Hotkeys.HOTKEY_LIST) {
            hotkey.getKeybind().setCallback((IHotkeyCallback)this);
        }
        Hotkeys.MASS_CRAFT_TOGGLE.getKeybind().setCallback((IHotkeyCallback)new KeyCallbackToggleBooleanConfigWithMessage((IConfigBoolean)Configs.Generic.MASS_CRAFT_HOLD));
    }

    public boolean functionalityEnabled() {
        return Configs.Generic.MOD_MAIN_TOGGLE.getBooleanValue();
    }

    public boolean onKeyAction(KeyAction action, IKeybind key) {
        if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue()) {
            ClickPacketBuffer.setShouldBufferClickPackets(true);
        }
        boolean cancel = this.onKeyActionImpl(action, key);
        ClickPacketBuffer.setShouldBufferClickPackets(false);
        return cancel;
    }

    private boolean onKeyActionImpl(KeyAction action, IKeybind key) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return false;
        }
        if (key == Hotkeys.TOGGLE_MOD_ON_OFF.getKeybind()) {
            Configs.Generic.MOD_MAIN_TOGGLE.toggleBooleanValue();
            String msg = this.functionalityEnabled() ? "itemscroller.message.toggled_mod_on" : "itemscroller.message.toggled_mod_off";
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.INFO, (String)msg, (Object[])new Object[0]);
            return true;
        }
        if (key == Hotkeys.OPEN_CONFIG_GUI.getKeybind()) {
            GuiBase.openGui((class_437)new GuiConfigs());
            return true;
        }
        if (!this.functionalityEnabled() || !(GuiUtils.getCurrentScreen() instanceof class_465) || Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName())) {
            return false;
        }
        class_465 gui = (class_465)GuiUtils.getCurrentScreen();
        class_1735 slot = AccessorUtils.getSlotUnderMouse(gui);
        RecipeStorage recipes = RecipeStorage.getInstance();
        MoveAction moveAction = InputUtils.getDragMoveAction(key);
        if (slot != null) {
            if (moveAction != MoveAction.NONE) {
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
                return InventoryUtils.dragMoveItems((class_465<? extends class_1703>)gui, moveAction, mouseX, mouseY, true);
            }
            if (key == Hotkeys.KEY_MOVE_EVERYTHING.getKeybind()) {
                InventoryUtils.tryMoveStacks(slot, (class_465<? extends class_1703>)gui, false, true, false);
                return true;
            }
            if (key == Hotkeys.DROP_ALL_MATCHING.getKeybind() && Configs.Toggles.DROP_MATCHING.getBooleanValue() && !Configs.GUI_BLACKLIST.contains(gui.getClass().getName()) && slot.method_7681()) {
                InventoryUtils.dropStacks((class_465<? extends class_1703>)gui, slot.method_7677(), slot, true);
                return true;
            }
        }
        if (key == Hotkeys.CRAFT_EVERYTHING.getKeybind()) {
            InventoryUtils.craftEverythingPossibleWithCurrentRecipe(recipes.getSelectedRecipe(), (class_465<? extends class_1703>)gui);
            return true;
        }
        if (key == Hotkeys.THROW_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.throwAllCraftingResultsToGround(recipes.getSelectedRecipe(), (class_465<? extends class_1703>)gui);
            return true;
        }
        if (key == Hotkeys.MOVE_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.moveAllCraftingResultsToOtherInventory(recipes.getSelectedRecipe(), (class_465<? extends class_1703>)gui);
            return true;
        }
        if (key == Hotkeys.STORE_RECIPE.getKeybind()) {
            if (InputUtils.isRecipeViewOpen() && InventoryUtils.isCraftingSlot((class_465<? extends class_1703>)gui, slot)) {
                recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true, true, mc);
                return true;
            }
        } else {
            if (key == Hotkeys.VILLAGER_TRADE_FAVORITES.getKeybind()) {
                return InventoryUtils.villagerTradeEverythingPossibleWithAllFavoritedTrades();
            }
            if (key == Hotkeys.SLOT_DEBUG.getKeybind()) {
                if (slot != null) {
                    InventoryUtils.debugPrintSlotInfo((class_465<? extends class_1703>)gui, slot);
                } else {
                    ItemScroller.LOGGER.info("GUI class: {}", (Object)gui.getClass().getName());
                }
                return true;
            }
            if (key == Hotkeys.SORT_INVENTORY.getKeybind() && Configs.Generic.SORT_INVENTORY_TOGGLE.getBooleanValue()) {
                InventoryUtils.sortInventory(gui);
                return true;
            }
        }
        return false;
    }

    public void onClientTick(class_310 mc) {
        if (InventoryUtils.dontUpdateRecipeBook > 0) {
            --InventoryUtils.dontUpdateRecipeBook;
        }
        if (!this.functionalityEnabled() || mc.field_1724 == null) {
            return;
        }
        ClickPacketBuffer.sendBufferedPackets(Configs.Generic.PACKET_RATE_LIMIT.getIntegerValue());
        if (ClickPacketBuffer.shouldCancelWindowClicks()) {
            return;
        }
        class_437 class_4372 = GuiUtils.getCurrentScreen();
        if (class_4372 instanceof class_465) {
            class_465 gui = (class_465)class_4372;
            if (!(GuiUtils.getCurrentScreen() instanceof class_481) && !Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName()) && (Hotkeys.MASS_CRAFT.getKeybind().isKeybindHeld() || Configs.Generic.MASS_CRAFT_HOLD.getBooleanValue())) {
                if (++this.massCraftTicker < Configs.Generic.MASS_CRAFT_INTERVAL.getIntegerValue()) {
                    return;
                }
                InventoryUtils.bufferInvUpdates = true;
                class_1735 outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui((class_465<? extends class_1703>)gui);
                if (outputSlot != null) {
                    if (Configs.Generic.RATE_LIMIT_CLICK_PACKETS.getBooleanValue()) {
                        ClickPacketBuffer.setShouldBufferClickPackets(true);
                    }
                    RecipePattern recipe = RecipeStorage.getInstance().getSelectedRecipe();
                    int limit = Configs.Generic.MASS_CRAFT_ITERATIONS.getIntegerValue();
                    if (Configs.Generic.MASS_CRAFT_RECIPE_BOOK.getBooleanValue() && recipe.getNetworkRecipeId() != null) {
                        InventoryUtils.dontUpdateRecipeBook = 2;
                        for (int i = 0; i < limit; ++i) {
                            class_8566 craftingInv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            if (recipe.getVanillaRecipe() != null && !recipe.getVanillaRecipe().method_8115((class_9695)craftingInv.method_59961(), (class_1937)mc.field_1687)) {
                                CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, outputSlot);
                                int invSlots = gui.method_17577().field_7761.size();
                                int rangeSlots = range.getSlotCount();
                                int j = 0;
                                for (int slotNum = range.getFirst(); j < rangeSlots && slotNum < invSlots; ++j, ++slotNum) {
                                    InventoryUtils.shiftClickSlot((class_465<? extends class_1703>)gui, slotNum);
                                    class_1735 slotTmp = gui.method_17577().method_7611(slotNum);
                                    class_1799 stack = slotTmp.method_7677();
                                    if (stack.method_7960()) continue;
                                    InventoryUtils.dropStack((class_465<? extends class_1703>)gui, slotNum);
                                }
                            }
                            mc.field_1761.method_2912(gui.method_17577().field_7763, recipe.getNetworkRecipeId(), true);
                            craftingInv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            if (recipe.getVanillaRecipe() != null && recipe.getVanillaRecipe().method_8115((class_9695)craftingInv.method_59961(), (class_1937)mc.field_1687)) break;
                            InventoryUtils.shiftClickSlot((class_465<? extends class_1703>)gui, outputSlot.field_7874);
                            InventoryUtils.dropStack((class_465<? extends class_1703>)gui, outputSlot.field_7874);
                            this.recipeBookClicks = true;
                        }
                        InventoryUtils.tryClearCursor((class_465<? extends class_1703>)gui);
                        InventoryUtils.throwAllCraftingResultsToGround(recipe, (class_465<? extends class_1703>)gui);
                    } else if (Configs.Generic.MASS_CRAFT_SWAPS.getBooleanValue()) {
                        for (int i = 0; i < limit; ++i) {
                            InventoryUtils.tryClearCursor((class_465<? extends class_1703>)gui);
                            InventoryUtils.setInhibitCraftingOutputUpdate(true);
                            InventoryUtils.throwAllCraftingResultsToGround(recipe, (class_465<? extends class_1703>)gui);
                            InventoryUtils.throwAllNonRecipeItemsToGround(recipe, (class_465<? extends class_1703>)gui);
                            class_8566 inv = ((IMixinCraftingResultSlot)outputSlot).itemscroller_getCraftingInventory();
                            try {
                                Thread.sleep(0L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            InventoryUtils.setCraftingGridContentsUsingSwaps((class_465<? extends class_1703>)gui, mc.field_1724.method_31548(), recipe, outputSlot);
                            InventoryUtils.setInhibitCraftingOutputUpdate(false);
                            InventoryUtils.updateCraftingOutputSlot(outputSlot);
                            if (InventoryUtils.areStacksEqual(outputSlot.method_7677(), recipe.getResult())) {
                                InventoryUtils.shiftClickSlot((class_465<? extends class_1703>)gui, outputSlot.field_7874);
                                continue;
                            }
                            break;
                        }
                    } else {
                        int failsafe = 0;
                        while (++failsafe < limit) {
                            InventoryUtils.tryClearCursor((class_465<? extends class_1703>)gui);
                            InventoryUtils.setInhibitCraftingOutputUpdate(true);
                            InventoryUtils.throwAllCraftingResultsToGround(recipe, (class_465<? extends class_1703>)gui);
                            InventoryUtils.throwAllNonRecipeItemsToGround(recipe, (class_465<? extends class_1703>)gui);
                            InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipe, (class_465<? extends class_1703>)gui, true);
                            InventoryUtils.setInhibitCraftingOutputUpdate(false);
                            InventoryUtils.updateCraftingOutputSlot(outputSlot);
                            if (InventoryUtils.areStacksEqual(outputSlot.method_7677(), recipe.getResult())) {
                                if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                                    InventoryUtils.dropStack((class_465<? extends class_1703>)gui, outputSlot.field_7874);
                                    continue;
                                }
                                InventoryUtils.dropStacksWhileHasItem((class_465<? extends class_1703>)gui, outputSlot.field_7874, recipe.getResult());
                                continue;
                            }
                            break;
                        }
                    }
                    ClickPacketBuffer.setShouldBufferClickPackets(false);
                }
                this.massCraftTicker = 0;
                InventoryUtils.bufferInvUpdates = false;
                InventoryUtils.invUpdatesBuffer.removeIf(packet -> {
                    packet.method_65081((class_2547)mc.method_1562());
                    return true;
                });
            }
        }
    }

    public void onPacket(class_2653 packet) {
        class_310 mc = class_310.method_1551();
    }
}

