/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.SortingCategory;
import fi.dy.masa.itemscroller.util.SortingMethod;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigLockedListType;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.IConfigValue;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigLockedList;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigStringList;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1734;
import net.minecraft.class_479;
import net.minecraft.class_490;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "itemscroller.json";
    private static final ImmutableList<String> DEFAULT_TOP_SORTING = ImmutableList.of((Object)"minecraft:diamond_sword", (Object)"minecraft:diamond_pickaxe", (Object)"minecraft:diamond_axe", (Object)"minecraft:diamond_shovel", (Object)"minecraft:diamond_hoe", (Object)"minecraft:netherite_sword", (Object)"minecraft:netherite_pickaxe", (Object)"minecraft:netherite_axe", (Object)"minecraft:netherite_shovel", (Object)"minecraft:netherite_hoe");
    private static final ImmutableList<String> DEFAULT_BOTTOM_SORTING = ImmutableList.of();
    private static final String GENERIC_KEY = "itemscroller.config.generic";
    private static final String TOGGLES_KEY = "itemscroller.config.toggles";
    public static final Set<String> GUI_BLACKLIST = new HashSet<String>();
    public static final Set<String> SLOT_BLACKLIST = new HashSet<String>();

    public static void loadFromFile() {
        Path configFile = FileUtils.getConfigDirectoryAsPath().resolve(CONFIG_FILE_NAME);
        if (Files.exists(configFile, new LinkOption[0]) && Files.isReadable(configFile)) {
            JsonElement element = JsonUtils.parseJsonFileAsPath((Path)configFile);
            if (element != null && element.isJsonObject()) {
                JsonObject root = element.getAsJsonObject();
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Hotkeys", Hotkeys.HOTKEY_LIST);
                ConfigUtils.readConfigBase((JsonObject)root, (String)"Toggles", Toggles.OPTIONS);
                Configs.getStrings(root, GUI_BLACKLIST, "guiBlacklist");
                Configs.getStrings(root, SLOT_BLACKLIST, "slotBlacklist");
            }
        } else {
            ItemScroller.LOGGER.error("loadFromFile(): Failed to load config file '{}'.", (Object)configFile.toAbsolutePath());
        }
        CraftingHandler.clearDefinitions();
        CraftingHandler.addCraftingGridDefinition(class_479.class.getName(), class_1734.class.getName(), 0, new CraftingHandler.SlotRange(1, 9));
        CraftingHandler.addCraftingGridDefinition(class_490.class.getName(), class_1734.class.getName(), 0, new CraftingHandler.SlotRange(1, 4));
    }

    public static void saveToFile() {
        Path dir = FileUtils.getConfigDirectoryAsPath();
        if (!Files.exists(dir, new LinkOption[0])) {
            FileUtils.createDirectoriesIfMissing((Path)dir);
        }
        if (Files.isDirectory(dir, new LinkOption[0])) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Generic", Generic.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Hotkeys", Hotkeys.HOTKEY_LIST);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Toggles", Toggles.OPTIONS);
            Configs.writeStrings(root, GUI_BLACKLIST, "guiBlacklist");
            Configs.writeStrings(root, SLOT_BLACKLIST, "slotBlacklist");
            JsonUtils.writeJsonToFileAsPath((JsonObject)root, (Path)dir.resolve(CONFIG_FILE_NAME));
        } else {
            ItemScroller.LOGGER.error("saveToFile(): Config Folder '{}' does not exist!", (Object)dir.toAbsolutePath());
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    private static void getStrings(JsonObject obj, Set<String> outputSet, String arrayName) {
        outputSet.clear();
        if (JsonUtils.hasArray((JsonObject)obj, (String)arrayName)) {
            JsonArray arr = obj.getAsJsonArray(arrayName);
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                outputSet.add(arr.get(i).getAsString());
            }
        }
    }

    private static void writeStrings(JsonObject obj, Set<String> inputSet, String arrayName) {
        if (!inputSet.isEmpty()) {
            JsonArray arr = new JsonArray();
            for (String str : inputSet) {
                arr.add(str);
            }
            obj.add(arrayName, (JsonElement)arr);
        }
    }

    public static class Generic {
        public static final ConfigBoolean CARPET_CTRL_Q_CRAFTING = (ConfigBoolean)new ConfigBoolean("carpetCtrlQCraftingEnabledOnServer", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean CLIENT_CRAFTING_FIX = (ConfigBoolean)new ConfigBoolean("clientCraftingFixOn1.12", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean CRAFTING_RENDER_RECIPE_ITEMS = (ConfigBoolean)new ConfigBoolean("craftingRenderRecipeItems", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean DEBUG_MESSAGES = (ConfigBoolean)new ConfigBoolean("debugMessages", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean MOD_MAIN_TOGGLE = (ConfigBoolean)new ConfigBoolean("modMainToggle", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean MASS_CRAFT_INHIBIT_MID_UPDATES = (ConfigBoolean)new ConfigBoolean("massCraftInhibitMidUpdates", true).apply("itemscroller.config.generic");
        public static final ConfigInteger MASS_CRAFT_INTERVAL = (ConfigInteger)new ConfigInteger("massCraftInterval", 2, 1, 60).apply("itemscroller.config.generic");
        public static final ConfigInteger MASS_CRAFT_ITERATIONS = (ConfigInteger)new ConfigInteger("massCraftIterations", 36, 1, 256).apply("itemscroller.config.generic");
        public static final ConfigBoolean MASS_CRAFT_SWAPS = (ConfigBoolean)new ConfigBoolean("massCraftSwapsOnly", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean MASS_CRAFT_RECIPE_BOOK = (ConfigBoolean)new ConfigBoolean("massCraftUseRecipeBook", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean MASS_CRAFT_HOLD = (ConfigBoolean)new ConfigBoolean("massCraftHold", false).apply("itemscroller.config.generic");
        public static final ConfigInteger PACKET_RATE_LIMIT = (ConfigInteger)new ConfigInteger("packetRateLimit", 4, 1, 1024).apply("itemscroller.config.generic");
        public static final ConfigBoolean SCROLL_CRAFT_STORE_RECIPES_TO_FILE = (ConfigBoolean)new ConfigBoolean("craftingRecipesSaveToFile", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean SCROLL_CRAFT_RECIPE_FILE_GLOBAL = (ConfigBoolean)new ConfigBoolean("craftingRecipesSaveFileIsGlobal", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean RATE_LIMIT_CLICK_PACKETS = (ConfigBoolean)new ConfigBoolean("rateLimitClickPackets", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean REVERSE_SCROLL_DIRECTION_SINGLE = (ConfigBoolean)new ConfigBoolean("reverseScrollDirectionSingle", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean REVERSE_SCROLL_DIRECTION_STACKS = (ConfigBoolean)new ConfigBoolean("reverseScrollDirectionStacks", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean USE_RECIPE_CACHING = (ConfigBoolean)new ConfigBoolean("useRecipeCaching", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean SLOT_POSITION_AWARE_SCROLL_DIRECTION = (ConfigBoolean)new ConfigBoolean("useSlotPositionAwareScrollDirection", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean VILLAGER_TRADE_USE_GLOBAL_FAVORITES = (ConfigBoolean)new ConfigBoolean("villagerTradeUseGlobalFavorites", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean VILLAGER_TRADE_LIST_REMEMBER_SCROLL = (ConfigBoolean)new ConfigBoolean("villagerTradeListRememberScrollPosition", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_INVENTORY_TOGGLE = (ConfigBoolean)new ConfigBoolean("sortInventoryToggle", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_ASSUME_EMPTY_BOX_STACKS = (ConfigBoolean)new ConfigBoolean("sortAssumeEmptyBoxStacks", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_SHULKER_BOXES_AT_END = (ConfigBoolean)new ConfigBoolean("sortShulkerBoxesAtEnd", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_SHULKER_BOXES_INVERTED = (ConfigBoolean)new ConfigBoolean("sortShulkerBoxesInverted", false).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_BUNDLES_AT_END = (ConfigBoolean)new ConfigBoolean("sortBundlesAtEnd", true).apply("itemscroller.config.generic");
        public static final ConfigBoolean SORT_BUNDLES_INVERTED = (ConfigBoolean)new ConfigBoolean("sortBundlesInverted", false).apply("itemscroller.config.generic");
        public static final ConfigStringList SORT_TOP_PRIORITY_INVENTORY = (ConfigStringList)new ConfigStringList("sortTopPriorityInventory", DEFAULT_TOP_SORTING).apply("itemscroller.config.generic");
        public static final ConfigStringList SORT_BOTTOM_PRIORITY_INVENTORY = (ConfigStringList)new ConfigStringList("sortBottomPriorityInventory", DEFAULT_BOTTOM_SORTING).apply("itemscroller.config.generic");
        public static final ConfigOptionList SORT_METHOD_DEFAULT = (ConfigOptionList)new ConfigOptionList("sortMethodDefault", (IConfigOptionListEntry)SortingMethod.CATEGORY_NAME).apply("itemscroller.config.generic");
        public static final ConfigLockedList SORT_CATEGORY_ORDER = (ConfigLockedList)new ConfigLockedList("sortCategoryOrder", (IConfigLockedListType)SortingCategory.INSTANCE).apply("itemscroller.config.generic");
        public static final ImmutableList<IConfigBase> OPTIONS = ImmutableList.of((Object)CARPET_CTRL_Q_CRAFTING, (Object)CLIENT_CRAFTING_FIX, (Object)CRAFTING_RENDER_RECIPE_ITEMS, (Object)DEBUG_MESSAGES, (Object)MASS_CRAFT_INHIBIT_MID_UPDATES, (Object)MASS_CRAFT_INTERVAL, (Object)MASS_CRAFT_ITERATIONS, (Object)MASS_CRAFT_SWAPS, (Object)MASS_CRAFT_RECIPE_BOOK, (Object)MASS_CRAFT_HOLD, (Object)MOD_MAIN_TOGGLE, (Object)PACKET_RATE_LIMIT, (Object[])new IConfigBase[]{RATE_LIMIT_CLICK_PACKETS, SCROLL_CRAFT_STORE_RECIPES_TO_FILE, SCROLL_CRAFT_RECIPE_FILE_GLOBAL, REVERSE_SCROLL_DIRECTION_SINGLE, REVERSE_SCROLL_DIRECTION_STACKS, SLOT_POSITION_AWARE_SCROLL_DIRECTION, USE_RECIPE_CACHING, VILLAGER_TRADE_USE_GLOBAL_FAVORITES, VILLAGER_TRADE_LIST_REMEMBER_SCROLL, SORT_INVENTORY_TOGGLE, SORT_ASSUME_EMPTY_BOX_STACKS, SORT_SHULKER_BOXES_AT_END, SORT_SHULKER_BOXES_INVERTED, SORT_BUNDLES_AT_END, SORT_BUNDLES_INVERTED, SORT_TOP_PRIORITY_INVENTORY, SORT_BOTTOM_PRIORITY_INVENTORY, SORT_METHOD_DEFAULT, SORT_CATEGORY_ORDER});
    }

    public static class Toggles {
        public static final ConfigBoolean CRAFTING_FEATURES = (ConfigBoolean)new ConfigBoolean("enableCraftingFeatures", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean DROP_MATCHING = (ConfigBoolean)new ConfigBoolean("enableDropkeyDropMatching", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean RIGHT_CLICK_CRAFT_STACK = (ConfigBoolean)new ConfigBoolean("enableRightClickCraftingOneStack", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_EVERYTHING = (ConfigBoolean)new ConfigBoolean("enableScrollingEverything", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_MATCHING = (ConfigBoolean)new ConfigBoolean("enableScrollingMatchingStacks", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_SINGLE = (ConfigBoolean)new ConfigBoolean("enableScrollingSingle", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_STACKS = (ConfigBoolean)new ConfigBoolean("enableScrollingStacks", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_STACKS_FALLBACK = (ConfigBoolean)new ConfigBoolean("enableScrollingStacksFallback", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SCROLL_VILLAGER = (ConfigBoolean)new ConfigBoolean("enableScrollingVillager", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SHIFT_DROP_ITEMS = (ConfigBoolean)new ConfigBoolean("enableShiftDropItems", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean SHIFT_PLACE_ITEMS = (ConfigBoolean)new ConfigBoolean("enableShiftPlaceItems", true).apply("itemscroller.config.toggles");
        public static final ConfigBoolean VILLAGER_TRADE_FEATURES = (ConfigBoolean)new ConfigBoolean("enableVillagerTradeFeatures", true).apply("itemscroller.config.toggles");
        public static final ImmutableList<IConfigValue> OPTIONS = ImmutableList.of((Object)CRAFTING_FEATURES, (Object)DROP_MATCHING, (Object)RIGHT_CLICK_CRAFT_STACK, (Object)SCROLL_EVERYTHING, (Object)SCROLL_MATCHING, (Object)SCROLL_SINGLE, (Object)SCROLL_STACKS, (Object)SCROLL_STACKS_FALLBACK, (Object)SCROLL_VILLAGER, (Object)SHIFT_DROP_ITEMS, (Object)SHIFT_PLACE_ITEMS, (Object)VILLAGER_TRADE_FEATURES, (Object[])new IConfigValue[0]);
    }
}

